/*
 * Decompiled with CFR 0.152.
 */
package jmaster.util.lang;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LangHelper {
    public static final long MS_IN_DAY = 86400000L;

    public static void handleRuntime(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new RuntimeException(throwable);
    }

    public static void handleRuntime(Exception exception) {
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }

    public static void throwRuntime(String string) {
        throw new RuntimeException(string);
    }

    public static void throwRuntime(String string, Exception exception) {
        throw new RuntimeException(string, exception);
    }

    public static void throwNotImplemented() {
        LangHelper.throwRuntime("Not implemented");
    }

    public static Map toMap(List list, String string) {
        HashMap hashMap = new HashMap();
        if (list != null) {
            try {
                for (int k = 0; k < list.size(); ++k) {
                    Object e2 = list.get(k);
                    Method method = e2.getClass().getMethod(string, null);
                    Object object = method.invoke(e2, (Object[])null);
                    hashMap.put(object, e2);
                }
            }
            catch (Exception exception) {
                LangHelper.handleRuntime(exception);
            }
        }
        return hashMap;
    }

    public static String toString(Collection collection, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator != null && iterator.hasNext()) {
            stringBuffer.append(string);
            stringBuffer.append("" + n++ + ". ");
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }

    public static String toString(Object[] objectArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray != null) {
            for (int k = 0; k < objectArray.length; ++k) {
                stringBuffer.append(string);
                stringBuffer.append("" + k + ". ");
                stringBuffer.append(objectArray[k]);
            }
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }

    public static Object toArray(List list, Class clazz) {
        Object object = null;
        if (list != null) {
            object = Array.newInstance(clazz, list.size());
            for (int k = 0; k < list.size(); ++k) {
                Array.set(object, k, list.get(k));
            }
        }
        return object;
    }

    public static Object toArray(List list) {
        return LangHelper.isEmpty(list) ? null : LangHelper.toArray(list, list.get(0).getClass());
    }

    public static Object toArray(Object[] objectArray, Class clazz) {
        Object object = null;
        if (objectArray != null) {
            object = Array.newInstance(clazz, objectArray.length);
            for (int k = 0; k < objectArray.length; ++k) {
                Array.set(object, k, objectArray[k]);
            }
        }
        return object;
    }

    public static int indexOf(Object[] objectArray, Object object) {
        int n = -1;
        if (object != null && objectArray != null) {
            for (int k = objectArray.length - 1; k >= 0 && n == -1; --k) {
                if (!object.equals(objectArray[k])) continue;
                n = k;
            }
        }
        return n;
    }

    public static boolean equals(Object object, Object object2) {
        boolean bl = false;
        if (object == null && object2 == null) {
            bl = true;
        } else if (object != null && object2 != null) {
            bl = object.equals(object2);
        }
        return bl;
    }

    public static boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    public static boolean isEmpty(List list) {
        return list == null || list.size() == 0;
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable throwable2 = throwable;
        while (throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        return throwable2;
    }

    public static void throwNotAllowed() {
        throw new RuntimeException("Not allowed");
    }

    public static void throwIfRuntime(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
    }

    public static Object nvl(Object ... objectArray) {
        Object object = null;
        int n = 0;
        while (object == null && objectArray != null && n < objectArray.length) {
            object = objectArray[n++];
        }
        return object;
    }

    public static Object instanceOf(Class<?> clazz, Object object) {
        return object != null && clazz.isAssignableFrom(object.getClass()) ? object : null;
    }

    public static Map toMap(Object ... objectArray) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(objectArray.length * 2);
        for (int k = 0; k < objectArray.length; k += 2) {
            hashMap.put(objectArray[k], objectArray[k + 1]);
        }
        return hashMap;
    }

    public static List toList(Object ... objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        for (int k = 0; k < objectArray.length; ++k) {
            arrayList.add(objectArray[k]);
        }
        return arrayList;
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.size() == 0;
    }
}

