#ifndef LIDSADM_H
#define LIDSADM_H

#define LIDS_PORT_ITEM  16
#define LIDS_TIME_ITEM  2

/* LIDSTools error codes */
#define LIDS_SUCCESS            0
#define LIDS_OOM_FAIL           1
#define LIDS_OPT_FAIL           2
#define LIDS_PROG_FAIL          3
#define LIDS_FILE_FAIL          4


/* LIDStools commands */
#define LIDS_NONE               -1
#define LIDS_ADD                1
#define LIDS_DELETE             2
#define LIDS_LIST               3
#define LIDS_DELETE_ALL         4
#define LIDS_MK_PASSWD          5
#define LIDS_SWITCH             6
#define LIDS_INIT               7
#define LIDS_UPDATE             8
#define LIDS_VIEW               9
#define LIDS_EXTEND             10

#define LIDS_DELETE_FLAG   100


/* File paths */
#define LIDS_LOCKS         "/proc/sys/lids/locks"
#define LIDS_CONF_FILE	   "/etc/lids/lids.conf"
#define LIDS_PW_FILE	   "/etc/lids/lids.pw"

/* Misc macros */
#define LIDS_CONF_COMMENT  "#\n# \tThis file is auto generated by lidsconf \n#\tPlease do not modify this file by hand\n#\n"



typedef struct lids_s {
	int	           type;	  /* access control type */
	unsigned long int  s_ino;	  /* subject inode number */
	unsigned int	   s_dev;	  /* subject dev number */
	char 	           s_file[1024];  /* subject filename */
	unsigned long int  o_ino;	  /* object inode number */
	unsigned int	   o_dev;	  /* object dev number*/
	char 	           o_file[1024];  /* oject filename */
	int	           inherit;	  /* inherit level */
	int		   time[LIDS_TIME_ITEM][2];	  /* from-to time*/
	int		   port[LIDS_PORT_ITEM][2];   /* bind port */
} lids_t;

extern char * disp_multi_data(int data[][2],int type);


#endif
