/***********************************************************************************

	Copyright (C) 2007-2008 Ahmet Öztürk (aoz_2@yahoo.com)
    
    Parts of this file are loosely based on an example gcrypt program
    on http://punkroy.drque.net/

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#include "helpers.hpp"

using namespace LIFEOHELPERS;

long LIFEOHELPERS::convert_string (const std::string& str) {
    //TODO: add negative number support
	long f_result=0;	// result
	for (unsigned int i=0;
         i<str.size() && i<10 && int (str[i])>='0' && int (str[i])<='9';
         i++) {
		f_result = (f_result * 10) + int (str[i]) - '0';
	}
	return (f_result);
}


std::ios::pos_type LIFEOHELPERS::get_file_size (std::ifstream& l_file) {
   std::ios::pos_type l_size;
   const std::ios::pos_type l_currentPosition = l_file.tellg();

   l_file.seekg(0, std::ios_base::end);
   l_size = l_file.tellg();
   l_file.seekg(l_currentPosition);

   return l_size;
}


void CIPHER::create_iv (unsigned char ** l_iv) {
	// (Allocate memory for and fill with strong random data)
	*l_iv = (unsigned char *) gcry_random_bytes(CIPHER::cIV_SIZE, GCRY_STRONG_RANDOM);

	if (! *l_iv)
		throw ERROR("Unable to create IV");
}

void CIPHER::expand_key (const char * l_passphrase,
                         const unsigned char* l_salt,
                         unsigned char ** l_key ) {
    gcry_md_hd_t Hash;
    gcry_error_t Error = 0;
    int HashDigestSize;
    unsigned char * HashResult;

    // OPEN MESSAGE DIGEST ALGORITHM
    Error = gcry_md_open(&Hash, cHASH_ALGORITHM, 0);
    if ( Error )
        throw ERROR("Unable to open message digest algorithm: %s"); //, gpg_strerror( Error ) );

    // RETRIVE DIGEST SIZE
    HashDigestSize = gcry_md_get_algo_dlen(cHASH_ALGORITHM);

    // ADD SALT TO HASH
    gcry_md_write(Hash, l_salt, cSALT_SIZE);

    // ADD PASSPHRASE TO HASH
    gcry_md_write( Hash , l_passphrase , strlen( l_passphrase ) );

    // FETCH DIGEST (THE EXPANDED KEY)
    HashResult = gcry_md_read( Hash , cHASH_ALGORITHM);

    if ( ! HashResult ) {
        gcry_md_close( Hash );
        throw ERROR( "Unable to finalize key" );
    }

    // ALLOCATE MEMORY FOR KEY
    // can't use the 'HashResult' because those resources are freed after the
    // hash is closed
    *l_key = new unsigned char [cKEY_SIZE];
    if ( ! l_key ) {
        gcry_md_close( Hash );
        throw ERROR("Unable to allocate memory for key");
    }

    // DIGEST SIZE SMALLER THEN KEY SIZE?
    if (HashDigestSize < cKEY_SIZE) {
        // PAD KEY WITH '0' AT THE END
        memset( *l_key , 0 , cKEY_SIZE );

        // COPY EVERYTHING WE HAVE
        memcpy( *l_key , HashResult , HashDigestSize );
    }
    else
        // COPY ALL THE BYTES WE'RE USING
        memcpy( *l_key , HashResult , HashDigestSize );

    // FINISHED WITH HASH
    gcry_md_close( Hash );
}

// CREATE NEW EXPANDED KEY
void CIPHER::create_new_key (char const * l_passphrase,
                             unsigned char ** l_salt,
                             unsigned char ** l_key) {
    // ALLOCATE MEMORY FOR AND FILL WITH STRONG RANDOM DATA
    *l_salt = (unsigned char *) gcry_random_bytes (cSALT_SIZE, GCRY_STRONG_RANDOM);
    
	if (! *l_salt)
		throw ERROR( "Unable to create salt value");

    expand_key(l_passphrase , *l_salt , l_key);
}

void CIPHER::encrypt_buffer (unsigned char * l_buffer,
							 size_t& l_size,
							 const unsigned char * l_key,
							 const unsigned char * l_iv) {
	gcry_cipher_hd_t	l_cipher;
	gcry_error_t		l_error = 0;

	l_error = gcry_cipher_open( &l_cipher , cCIPHER_ALGORITHM , cCIPHER_MODE , 0 );

	if (l_error)
		throw ERROR("Unable to initilize cipher: "); // + gpg_strerror( Error ) );

	// GET KEY LENGTH
	int l_cipherKeyLength = gcry_cipher_get_algo_keylen (cCIPHER_ALGORITHM);
	if (!l_cipherKeyLength)
		throw ERROR( "gcry_cipher_get_algo_keylen failed");

	// SET KEY
	l_error = gcry_cipher_setkey (l_cipher, l_key, l_cipherKeyLength);
	if (l_error) {
		gcry_cipher_close (l_cipher);
		throw ERROR("Cipher key setup failed: %s"); //, gpg_strerror( Error ) );
	}

	// SET INITILIZEING VECTOR (IV)
	l_error = gcry_cipher_setiv(l_cipher, l_iv, cIV_SIZE);
	if ( l_error ) {
		gcry_cipher_close(l_cipher);
		throw ERROR("Unable to setup cipher IV: %s");// , gpg_strerror( Error ) );
	}

	// ENCRYPT BUFFER TO SELF
	l_error = gcry_cipher_encrypt(l_cipher, l_buffer, l_size, NULL, 0);

	if (l_error) {
		gcry_cipher_close(l_cipher);
		throw ERROR("Encrption failed: %s"); // , gpg_strerror( Error ) );
	}

	gcry_cipher_close(l_cipher);
}

void CIPHER::decrypt_buffer (	unsigned char * l_buffer,
								size_t& l_size,
								const unsigned char * l_key,
								const unsigned char * l_iv) {
	gcry_cipher_hd_t	l_cipher;
	gcry_error_t		l_error = 0;

	l_error = gcry_cipher_open( &l_cipher , cCIPHER_ALGORITHM , cCIPHER_MODE , 0 );

	if (l_error)
		throw ERROR("Unable to initilize cipher: "); // + gpg_strerror( Error ) );

	// GET KEY LENGTH
	int l_cipherKeyLength = gcry_cipher_get_algo_keylen (cCIPHER_ALGORITHM);
	if (!l_cipherKeyLength)
		throw ERROR( "gcry_cipher_get_algo_keylen failed");

	// SET KEY
	l_error = gcry_cipher_setkey (l_cipher, l_key, l_cipherKeyLength);
	if (l_error) {
		gcry_cipher_close (l_cipher);
		throw ERROR("Cipher key setup failed: %s"); //, gpg_strerror( Error ) );
	}

	// SET IV
	l_error = gcry_cipher_setiv(l_cipher, l_iv, cIV_SIZE);
	if ( l_error ) {
		gcry_cipher_close(l_cipher);
		throw ERROR("Unable to setup cipher IV: %s");// , gpg_strerror( Error ) );
	}

	// DECRYPT BUFFER TO SELF
	l_error = gcry_cipher_decrypt(l_cipher, l_buffer, l_size, NULL, 0);

	if (l_error) {
	    gcry_cipher_close(l_cipher);
		throw ERROR("Encrption failed: %s"); // , gpg_strerror( Error ) );
	}

	gcry_cipher_close(l_cipher);
}

