/***********************************************************************************

	Copyright (C) 2009 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_DIALOG_TAGEDITOR_HEADER
#define LIFEOGRAPH_DIALOG_TAGEDITOR_HEADER


#include <gtkmm/dialog.h>
#include <gtkmm/entry.h>
#include <gtkmm/button.h>
#include <gtkmm/stock.h>

#include "database.hpp"


namespace LIFEO
{

class ColrecTag : public Gtk::TreeModel::ColumnRecord
{
	public:
		ColrecTag()
		{
			add( m_icon );
			add( m_name );
			add( m_ptr2tag );
			add( m_separator );
		}
		Gtk::TreeModelColumn< Glib::RefPtr< Gdk::Pixbuf > >
												m_icon;
		Gtk::TreeModelColumn< Glib::ustring >	m_name;
		Gtk::TreeModelColumn< Tag* >			m_ptr2tag;
		Gtk::TreeModelColumn< bool >			m_separator;
};

// COMBOBOXENTRY FOR TAGS
class Tagwidget : public Gtk::ComboBoxEntry
{
	public:
		enum OperationType
		{
			OT_EDIT,
			OT_CREATE
		};
									Tagwidget( OperationType );

		void						set_model( const Glib::RefPtr< Gtk::TreeModel >& );
		void						set_text_column( const Gtk::TreeModelColumnBase& );

		bool						is_activatable( void ) const
		{ return m_flag_activatable; }

		virtual void				on_remove( Gtk::Widget* );
		virtual void				on_activate( void );
		SignalVoid					signal_activate( void )
		{ return m_signal_activate; }

		void						handle_icon_release(	Gtk::EntryIconPosition,
															const GdkEventButton* );

	protected:
		void						on_changed( void );

		EntryIdletext				m_entry;
		Glib::RefPtr< Gtk::TreeModel >
									m_model;
		Glib::RefPtr< Gtk::EntryCompletion >
									m_entrycompletion;
		bool						m_flag_activatable;
		bool						m_flag_empty;
		OperationType				m_operation;

		SignalVoid					m_signal_activate;
};

// TAG EDITOR DIALOG
class DialogTageditor : public Gtk::Dialog
{
	public:
									DialogTageditor( Tag* );

		Glib::ustring				get_tagname( void );

		void						handle_tagname_changed( void );

	protected:
		//Gtk::TreeView				*m_treeview_tags;
		Tagwidget					*m_tagwidget;
		Gtk::Button					*m_button_create;

		Glib::RefPtr< Gtk::ListStore >
									m_liststore_tag;

	private:
		Glib::ustring				m_tagname;
		Tag							*m_ptr2tag;
};

} // end of namespace LIFEO

#endif

