/***********************************************************************************

	Copyright (C) 2009 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_DIALOG_THEME_HEADER
#define LIFEOGRAPH_DIALOG_THEME_HEADER


#include <gtkmm/dialog.h>
#include <gtkmm/button.h>
#include <gtkmm/stock.h>

#include "database.hpp"
#include "textview.hpp"


namespace LIFEO
{


class DialogTheme : public Gtk::Dialog
{
	public:
								DialogTheme( Database*, TextbufferDiary* );

		void					handle_checkbutton_toggled( void );
		void					handle_fontbutton_changed( void );
		void					handle_color_bg_changed( void );
		void					handle_color_fg_changed( void );
		void					handle_color_heading_changed( void );
		void					handle_color_subheading_changed( void );
		void					handle_color_highlight_changed( void );

		void					update_database( void );

	protected:
		virtual void			on_response( int );

		Database				*m_ptr2database;
		TextbufferDiary			*m_ptr2buffer;

		Gtk::CheckButton		m_checkbutton;
		Gtk::Table				m_table;
		Gtk::Label				m_label_font;
		Gtk::Label				m_label_colors;
		Gtk::Label				m_label_bg;
		Gtk::Label				m_label_fg;
		Gtk::Label				m_label_heading;
		Gtk::Label				m_label_subheading;
		Gtk::Label				m_label_highlight;
		Gtk::FontButton			m_fontbutton;
		Gtk::ColorButton		m_colorbutton_bg;
		Gtk::ColorButton		m_colorbutton_fg;
		Gtk::ColorButton		m_colorbutton_heading;
		Gtk::ColorButton		m_colorbutton_subheading;
		Gtk::ColorButton		m_colorbutton_highlight;

	private:

};

} // end of namespace LIFEO

#endif

