// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// C++ Implementation: AxForward
//
// Description: 
//
//
// Author: Janusz SP9UMX <sp9umx@sr9zaa.ampr.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

// QT
#include <qfile.h>
#include <qdir.h>
#include <qapplication.h>
#include <qsocket.h>

#include <stropts.h>

// Classess
#include "AxForward.h"
#include "utils.h"
#include "AxUnit.h"
#include "event.h"
#include "statusw.h"
#include "llista.h"
#include "lzhuf.h"


extern TAxUnit AxU;
extern TUtils Util;
extern TStatus *StatusW;
extern TList_window *List_window;

// Global variables
extern QString  PrgPath;
extern bool  IsTelnet;
extern QString mycall;
extern QString  SID;
extern FILE *FileDescriptor;
extern QSocket Socket;


#define  ABORT_ADDR  "forward"
#define  EXIT_OK     0
#define  EXIT_FILE   1
#define  EXIT_LINK   2
#define  EXIT_ABORT  3
#define  EXIT_OTHER  4
// max. size of one message block [kB]
#define  MSG_BLOCK_SIZE  10240   

#define  NUL  0
#define  SOH  1
#define  STX  2
#define  EOT  4

#define BSIZE 253
// was 250
#define MAXLENGTH 31000  // max length of message

// 
//     var
int       bbs_connected;  /* BBS is connected */
QFile     indexf;         /* index file */
QString   homebbs;        /* path to home BBS - port:CALL [CALL ...] */
QString   homeaddrs;      /* hierarchical address of home BBS */
int       msgnum;         /* actual message number */
QChar     mode;           /* p = personal, b = bulletin */
QString   title;          /* message data */
QString   from;
QString   to_a;
QString   mid;
QString   date;
QString   flags;
long      size;           /* current message size */
long      block_size;     /* current block size */
msgrec    msgrecord[6];   /* msg. block - FBB allows max. 5 records */
int       records;        /* number of records in actual block (max 5) */

QMemArray<char> buf_forw (MAXLENGTH);
QMemArray<char> buf_out (MAXLENGTH);

TAxForward::TAxForward()
{
	stopped = FALSE;
}


void TAxForward::run()
{
	if (!stopped)  ForwardEvent();
	stopped = FALSE;
}

void TAxForward::stop()
{
	stopped = TRUE;
}




void  TAxForward::UpdateStatus( int progress, int progressMax, QString L_Stat, QString L_MNr, QString L_MT, bool reset )
{
	StatusUpdateClass stt;
     
	stt.progress = progress;
	stt.progressMax = progressMax;
	stt.L_Stat = L_Stat;
	stt.L_MNr = L_MNr;
	stt.L_MT = L_MT;
	stt.reset = reset;
     
	StatUpdateEvent* stupd = new StatUpdateEvent( stt );
	QApplication::postEvent( StatusW, stupd );  // Qt will delete it when done
  
}


QString TAxForward::striplf( QString s )
{
	
	if ( s.endsWith ( "\r" ) ) s.replace( s.length()-1, 1 , "\n" );
	return s;
}

//     ///* strip SSID from callsign */
QString TAxForward::call_call ( QString src )
{
	QString s;
	int p;
	
	p = src.find("-",0,FALSE);
	s = src.upper();
	if ( p >= 0 ) s.truncate(p);
	return s;
}

//     //* -------------------------------------------------------------------- */

//     ///* send FQ to disconnect BBS */
void TAxForward::send_FQ()
{
	AxU.SendLine( "FQ", TRUE );
}

//     //* mark a record in index file as forwarded */
void TAxForward::mark_record( int msgnum )
{
	idx_record idx_tmp;
	QString tmp;
		
	idx_tmp = Util.idx_load('i', msgnum );
	if (idx_tmp.flag == "W" ) idx_tmp.flag = "F";
	if (idx_tmp.flag == "V" ) idx_tmp.flag = "G";
	Util.idx_save('i', idx_tmp );
	tmp = PrgPath + "queue/" + idx_tmp.number.stripWhiteSpace() + ".idx";
	if ( ! QFile::remove( tmp ) )
		QMessageBox::critical(List_window, "Error","File " ); //+ tmp + ".idx not found !!");
}

//     //* sends compressed data from file to output */
//     //* using FBB compressed protocol version 0 */
int TAxForward::send_data( QString subject, char* body_o, long size )
{
	
	short sum;
	long i,k;
	long pos,r;
	char *p;
	
	p = body_o;
	pos = 0;
	striplf( subject );
	//void  TAxForward::UpdateStatus( int progress, int progressMax, QString L_Stat, QString L_MNr, QString L_MT, bool reset )
	UpdateStatus( 0, size, "", "" , "", TRUE );

//  NUL  0
//  SOH  1
//  STX  2
//  EOT  4
	
	
	// *HEADERR* //
	fputc( SOH, FileDescriptor );
	fputc( subject.length()+8, FileDescriptor );
	fprintf(FileDescriptor,"%s",subject.ascii());
	fputc( NUL, FileDescriptor );
	fprintf(FileDescriptor, "     0");
	fputc( NUL, FileDescriptor);
	
	fflush(FileDescriptor);
	
	//* data * //
	sum = 0;

	while ( pos < size )
	{
		r = (pos + BSIZE >= size) ? size-pos : BSIZE;
		fputc( STX, FileDescriptor );
		fputc( r, FileDescriptor );
		
		
		k=0;
		for ( i=0; i < r; i++)
		{
			sum += *p;
			fwrite(p, sizeof(char), 1, FileDescriptor);
			if ( IsTelnet &&  (p[i] == (char)(0xff))) fputc( 0xff, FileDescriptor );
			UpdateStatus( pos + k, 0, "", "", "", FALSE );
			p++;
			k++;
		}
		pos += r;
		fflush(FileDescriptor);
		

	}
	
	fputc( EOT, FileDescriptor );
	fputc( -sum, FileDescriptor );
	fflush(FileDescriptor);
	
	return 1;
}

    //* send a block of messages */
void TAxForward::send_block()
{
	int i;
	int blocks;
	int p;
	QString s;
	
	//* count messages * //
	blocks = 0;
	for ( i = 0; i <= 4; i++ )
		if ( msgrecord[i].ok != 0 ) blocks++; 
	if ( blocks == 0 ) return;
	
	
	
	//* send proposals */
	for ( i = 0; i <= 4; i++ )
		if ( msgrecord[i].ok != 0 ) AxU.SendLine( msgrecord[i].proposal, TRUE );

	
	AxU.SendLine( "F>", TRUE );
	s=AxU.GetLine();
	
//	if ( IsTelnet ) s=AxU.GetLine();     // Cause of $0D $0A as CR and LF in telnet
                                           // AX25 uses only $0D

	
// 	do 
// 	{
// 		QMessageBox::information( List_window, "Title", "przed GetLine = " + s );
// 		s = AxU.GetLine();
// 		QMessageBox::information( List_window, "Title", "GetLine = " + s );	
// 
// 	}
// 	while ( s != "\r" );  // \r = 0x0d

	
	//* decode answer *//
	p = 3;
	for ( i = 0; i <= 4; i++ )
		if ( msgrecord[i].ok != 0 )
		{
			if ( s[p] == '+' || s[p] == 'Y' )
			{
				msgrecord[i].send = 1;
				msgrecord[i].let = 0;
				p++;
			}
			else
			if ( s[p] == '-' || s[p] == 'N' )
			{
				msgrecord[i].send = 0;
				msgrecord[i].let = 0;	
			}
			else
			if ( s[p] == '=' || s[p] == 'L' )
			{
				msgrecord[i].send = 0;
				msgrecord[i].let = 1;
				p++;
			}
			else
				p++;
		}
		
	//* send data */
	for ( i = 0; i <= 4; i++ )
		if ( msgrecord[i].ok != 0 && msgrecord[i].send != 0 )
		{
			send_data( msgrecord[i].subject, msgrecord[i].body, msgrecord[i].size );
			//delete msgrecord[i].body;
		}
		
	s = AxU.GetLine();     //* wait for FF
                               // both ax25 and telnet(!!) sends only $0D as EOL - strange !!!
	
	if (s.find( "FF", 0, TRUE ) == -1 )
	{
	   QMessageBox::critical( List_window, "Error", "Error on message forward. BBS's answer: " + s );
	   AxU.DiscBBS();
	   return;
	}
	else
			
	//* mark sent messages */	
	for ( i = 0; i <= 4; i++ )
		if ( msgrecord[i].ok != 0 ) 
		{
			if ( msgrecord[i].let == 0 ) mark_record( msgrecord[i].num );
			msgrecord[i].ok = 0;
		}
	
	records = 0;
	block_size = 0;
								
}

//* prepare a message for sending in next block */
int TAxForward::forward_message( int num, QString types,QString mid,QString from,QString to_a,QString at,QString subject)
{
	QString s;
	QString body;
	long csize,sz;
	int i;

	
	s = PrgPath + "mail/" + QString::number(num);
	
	QFile fl (s);
	if ( fl.open( IO_ReadOnly ) )  
	{
		buf_forw = fl.readAll();
		fl.close();
	}
	
	lzhuf_init(1);
	lzhuf_encode(buf_forw.size(), &buf_forw.at(0) );		
	
	csize = lzhuf_length();

	char *cbody = new char[csize+4];
	memcpy(&cbody[4],lzhuf_data(), csize);
	
	
	//* add size of uncompressed file */
	sz = buf_forw.size();
	for (i=0; i<=3; i++)
	{
		cbody[i] = sz % 256;
		sz = sz / 256;
	}

	
	csize += 4;
		
	//* if block is large enough, send it */
	if ( block_size + size > MSG_BLOCK_SIZE) send_block();	
	
	msgrecord[records].proposal = "FA "+types.upper()+" "+from+" "+at.stripWhiteSpace()+" "+to_a+" "+mid+" "+QString::number(buf_forw.size());
	msgrecord[records].subject = subject;
	msgrecord[records].body = cbody;
	msgrecord[records].size = csize;
	msgrecord[records].offset = 0;
	msgrecord[records].num = num;
	msgrecord[records].ok = 1;
	records++;
	block_size += csize;

	if (records > 5) send_block();
	lzhuf_free();

	return 1;
}


     //* scan message index and prepare messages marked for forward */
void TAxForward::start_forward()
{
	QString s;
	idx_record idx_tmp;
	
	records = 0;
	
	QDir dir = (PrgPath+"queue/");
	dir.setFilter( QDir::Files | QDir::NoSymLinks );
	dir.setNameFilter( "*.idx" );
	dir.setSorting( QDir::Name );
  
	const QFileInfoList *list = dir.entryInfoList();
	QFileInfoListIterator it( *list );
	QFileInfo *fi;

	
	while ( (fi = it.current()) != 0 ) 
	{
		s = fi->fileName();
		s .truncate(s.length() - 4);
		idx_tmp = Util.idx_load('q', s.toInt() );
		if (s.toInt() != idx_tmp.number.toInt() )  
			QMessageBox::critical( List_window, "Idx",  "Wrong message idx and its number inside idx-file" + fi->fileName() );
		mid = idx_tmp.number.stripWhiteSpace() + "_" + mycall;
		forward_message(s.toInt(),idx_tmp.flag,mid,idx_tmp.from,idx_tmp.to_a,idx_tmp.at,idx_tmp.subject);
		
		++it;
	}
	send_block();
	
}

void TAxForward::ForwardEvent()
{
	StatusW->show();
	UpdateStatus(0,0,"Status : Connecting ...","Message nr : ", "Message Title : ",TRUE);
	
	if (AxU.ConnectBBS() )
	{
		UpdateStatus(0,0,"Status : Sending command ...", "", "", FALSE );
		AxU.SendLine(SID,TRUE);
		UpdateStatus(0,0,"Status : Sending message ...", "", "", FALSE );
		start_forward();
		UpdateStatus(0,0,"Status : Message sent", "", "", FALSE );
		send_FQ();
		AxU.DiscBBS();
	}
	else
	{
		QMessageBox::critical( List_window, "Connection error",  "Cannot connect to BBS" );
	} //if (AxU.ConnectBBS()) else
  
	StatusW->hide();
	stopped = TRUE;

}

