// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// C++ Interface: %{MODULE}
//
// Description: 
//
//
// Author: Janusz SP9UMX <sp9umx@sr9zaa.ampr.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#define USEREVENT 65431

class ShExLineEvent : public QCustomEvent
{
  public:
     ShExLineEvent( QString line )
            : QCustomEvent( USEREVENT+1 ), ln( line ) {}
     QString line() const { return ln; }
  private:
     QString ln;
};


class LiViLineEvent : public QCustomEvent
{
  public:
     LiViLineEvent( QString line )
            : QCustomEvent( USEREVENT+2 ), ln( line ) {}
     QString line() const { return ln; }
  private:
     QString ln;
};

class StatusUpdateClass
{
  public:
    int progress;
    int progressMax;
    QString L_Stat;
    QString L_MNr;
    QString L_MT;
    bool reset;
};

class StatUpdateEvent : public QCustomEvent
{
  public:
     StatUpdateEvent( StatusUpdateClass st ) : QCustomEvent( USEREVENT+3 ), st_( st ) {}
     StatusUpdateClass st() const { return st_; }
  private:
     StatusUpdateClass st_;
};

