/****************************************************************************
**
** $Id: DirConnector.cpp,v 1.7 2004/03/03 15:02:06 hemer Exp $
**
** Copyright (C) 1999-2004 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Frank Hemer <frank@hemer.org>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Tom Mishima <tmishima@mail.at-m.or.jp>
**    Joerg Preiss <auba@auba.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your  option) any later version.  This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "config.h"

#include "DirConnector.h"
#include "qapplication.h"
#include "Timer.h"

DirConnector::DirConnector() : suspended(false), m_running(false), m_lock(false) {

}

DirConnector::~DirConnector() {

}

Directory* DirConnector::checkEvent(QString& file,bool& deleted) {

  if ( dirQueue.empty()) return NULL;
  else {
    const dirData * first = dirQueue.front();
    dirQueue.erase(dirQueue.begin());
    Directory * dir = first->dir;
    file = first->fileName;
    deleted = first->deleted;
    delete first;
    return dir;
  }
}

bool DirConnector::addToDirQueue(Directory * addDir, QString& fileName, bool& deleted) {
  if (suspended) return FALSE;
  dirData * dd = new dirData();
  dd->dir = addDir;
  dd->fileName = fileName;
  dd->deleted = deleted;
  QValueVector<dirData*>::const_iterator it = qFind( dirQueue.begin(), dirQueue.end(), dd );//only add if not jet in queue
  if ( it == dirQueue.end()) {
    dirQueue.push_back(dd);
    if (!m_lock) {
      emit eventReceived();
    }
    return TRUE;
  } else delete dd;
  return FALSE;
}

void DirConnector::clearDirQueue() {
  dirQueue.clear();
}

void DirConnector::suspend() {
  qApp->processEvents();//first clear pending events
  suspended = true;
}

void DirConnector::resume() {
  qApp->processEvents();//first clear pending events
  suspended = false;
}

void DirConnector::lock() {
  m_lock = true;
}

void DirConnector::unlock() {
  m_lock = false;
  if (!dirQueue.empty()) {
    Timer::singleShot(0,this,SLOT(emitNotification()));
  }
}

void DirConnector::setRunning( bool state) {
  m_running = state;
}

bool DirConnector::isRunning() {
  return m_running;
}

void DirConnector::emitNotification() {
  emit eventReceived();
}
