/****************************************************************************
**
** $Id: Validators.cpp,v 1.5 2004/05/04 13:18:58 hemer Exp $
**
** Copyright (C) 2003-2004 Frank Hemer <frank@hemer.org>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your  option) any later version.  This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "Validators.h"

#include <qobject.h>
#include <qmessagebox.h>

RevisionValidator::State RevisionValidator::validate ( QString & input, int & ) const {

  unsigned int i;
  for (i=0; i<input.length(); ++i) {
    QChar c = input.at(i);
    if (c.isDigit()) continue;
    else if (c == '.') continue;
    return Invalid;
  }
  if ( input.find("..") > -1 ) return Invalid;
  return Acceptable;
}

TagValidator::State TagValidator::validate ( QString & input, int &) const {

  unsigned int i;

  for (i=0 ; i<input.length(); ++i) {
    QChar c = input.at(i);
    if (i==0) {
      if (c.isLetter()) continue;
      else return Invalid;
    } else {
      if (c.isLetterOrNumber()) continue;
      else if (c.category()==QChar::Punctuation_Connector) continue;
      else if (c.category()==QChar::Punctuation_Dash) continue;
      else if (c.category()==QChar::Symbol_Math) continue;
      else if (c.category()==QChar::Punctuation_Other) {
	if (c == '\'' ||
	    c == '\"' ||
	    c == '$' ||
	    c == ',' ||
	    c == '.' ||
	    c == ':' ||
	    c == ';' ||
	    c == '@'
	    ) return Invalid;
	continue;
      }
      return Invalid;
    }
  }
  return Acceptable;
}

void ValidatorWarning::TagWarning(QWidget * parent) {
  QString msg = QObject::tr("You need to specify a tag");
  QMessageBox::warning(parent, QObject::tr("Tag missing"),msg,QMessageBox::Ok, QMessageBox::NoButton);
}

void ValidatorWarning::RevisionWarning(QWidget * parent) {
  QString msg = QObject::tr("You need to specify a revision number");
  QMessageBox::warning(parent, QObject::tr("Revision number missing"),msg,QMessageBox::Ok, QMessageBox::NoButton);
}

void ValidatorWarning::DateWarning(QWidget * parent) {
  QString msg = QObject::tr("You need to specify a date");
  QMessageBox::warning(parent, QObject::tr("Date missing"),msg,QMessageBox::Ok, QMessageBox::NoButton);

}

void ValidatorWarning::TagAndOrDateWarning(QWidget * parent) {
  QString msg = QObject::tr("You need to specify a tag and/or date");
  QMessageBox::warning(parent, QObject::tr("Tag and/or date missing"),msg,QMessageBox::Ok, QMessageBox::NoButton);

}
