/***************************************************************************
                          cdromctrl.cpp  -  description
                             -------------------
    begin                : Sat Feb 22 2003
    copyright            : (C) 2003 by Sheldon Lee Wen
    email                : leewsb@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <lineak/cdromctrl.h>

extern "C" {
#include <fcntl.h>
#include <sys/ioctl.h>
#if defined (__FreeBSD__)
	# include <sys/cdio.h>
	#define CDROMEJECT CDIOCEJECT /*_IO('c', 107)*/
	#define CDROMCLOSETRAY CDIOCCLOSE
#else
#  include <linux/version.h>
#  if LINUX_VERSION_CODE >= KERNEL_VERSION(2,5,70)
     typedef unsigned char u8;
#  endif
#  undef __STRICT_ANSI__
#  include <linux/cdrom.h>
#  define __STRICT_ANSI__
#endif

#include <sys/stat.h>
#include <sys/types.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
}
#include <iostream>

#include <lineak/lineak_core_functions.h>
extern bool verbose;


cdromCtrl::cdromCtrl(){
	cdromdev = null;
	cdromstatus = false;
}
cdromCtrl::cdromCtrl(string cdrom){
	cdromdev = cdrom;
	cdromstatus = false;
 init();
}
cdromCtrl::~cdromCtrl(){
}
/** Read property of string cdromdev. */
const string& cdromCtrl::getCdromdev(){
	return cdromdev;
}
/** Write property of string cdromdev. */
void cdromCtrl::setCdromdev( const string& _newVal){
	cdromdev = _newVal;
	cdromstatus = false;
	init();
}
/** Initialze the cdrom device. Disable sw eject */
void cdromCtrl::init(){
	int fp;
   
   if (verbose) cout << "CD-ROM init, using " << cdromdev << " as the CD-ROM device" << endl;
  	/* do we have a CD-ROM device configured?  (REDUNDANT extra check) */
  	if ( cdromdev != null) {
		/* try to open the device .. */
    	if ( (fp = open(cdromdev.c_str(), O_RDONLY | O_NONBLOCK)) != -1 ) {
	  		/* tell the drive to diable auto-eject */
				#if defined (__FreeBSD__)
				if ( (ioctl(fp, CDIOCPREVENT)) == -1 )
				#else
				if ( (ioctl(fp, CDROMEJECT_SW, 0)) == -1 )
				#endif
        		cerr << "... oops! error during CD-ROM init" << endl;
	  			close(fp);
			} else
	  			cerr << "... oops! unable to open the CD-ROM device " << cdromdev << "(CD-ROM init)" << endl;

  	} else
		cerr << "no CD-ROM device configured! (CD-ROM init)" << endl;
}
/** Eject the cdrom device. */
void cdromCtrl::eject(){
  	int fp;
  	/* do we have a CD-ROM device configured?  (extra check, not really nescessary) */
  	if ( cdromdev != null) {
		/* try to open the device .. */
    	if ( (fp = open(cdromdev.c_str(), O_RDONLY | O_NONBLOCK)) != -1 ) {
	  		if (!cdromstatus) { /* assumed closed */
				/* enable the drives software eject */
				#if defined (__FreeBSD__)
				if ( (ioctl(fp, CDIOCALLOW)) == -1 )
				#else
				if ( (ioctl(fp, CDROMEJECT_SW, 1)) == -1 )
				#endif
        	cout << "... oops! error enabling CD-ROM SW eject" << endl;
				/* eject the cdrom tray */
				if (verbose) cout << "... ejecting the CD-ROM tray" << endl;
        		if ( (ioctl(fp, CDROMEJECT)) == -1 )
          			cerr << "... oops! failed to eject the CD-ROM" << endl;
				else
		  			cdromstatus = !cdromstatus;
	  		} else { /* assumed open */
        		/* disable the drives software eject again.. */
						#if defined (__FreeBSD__)
						if ( (ioctl(fp, CDIOCPREVENT)) == -1 )
						#else
        		if ( (ioctl(fp, CDROMEJECT_SW, 0)) == -1 )
          	#endif
          			cerr << "... oops! error disabling CD-ROM SW eject" << endl;
				/* close the cdrom tray */
				if (verbose) cout << "... closing the CD-ROM tray" << endl;
        		if ( (ioctl(fp, CDROMCLOSETRAY)) == -1 )
          			cerr << "... oops! failed to close the CD-ROM" << endl;
				else
		  			cdromstatus = !cdromstatus;
	  		}
      		close(fp);
		} else {
			cerr << "... oops! unable to open the CD-ROM device " << cdromdev << endl;
		}
  	} else
		cerr << "... oops! no CD-ROM device configured!" << endl;
}
   
