/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Wed Jan  1 14:03:54 EST 2003
    copyright            : (C) 2003 by Sheldon Lee Wen
    email                : leewsb@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <iostream>
#include <iomanip>

#if __GNUC__ >= 3
   #include <ostream>
#else
   	#include <ostream.h>
#endif

#if defined (__FreeBSD__)
 #define SIGCLD SIGCHLD
#else
 #define SIGCLD SIGCLD
#endif
// lineakd.c definitions, not sure if they are necessary here
/* system header files */

extern "C" {
#include <signal.h>
#include <X11/Xlib.h>
#include <X11/Xlibint.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/Xos.h>
#include <X11/Xmu/Error.h>
#include <X11/Xmu/Xmu.h>
#include <X11/extensions/scrnsaver.h>
}

#ifndef X_NOT_STDC_ENV
  #include <stdlib.h>
#else
  extern char *getenv();
#endif


//#ifdef HAVE_XOSD
 // #include "xosdctrl.h"
//	xosdCtrl *myDisplay = 0;
//#endif
#include <lineak/displayctrl.h>
displayCtrl *myDisplay = 0;

#include <lineakd_core_functions.h>
#include <lineak/lineak_core_functions.h>
#include <lineak/lineak_util_functions.h>
#include <lineak/configloader.h>
#include <lineak/defloader.h>
#include <lineak/lkbd.h>
#include <lineak/lkey.h>
#include <lineak/lbutton.h>
#include <lineak/ldef.h>
#include <lineak/saver.h>
#include <lineak/xmgr.h>
#include <cmdprefs.h>
//#include <lineak/soundctrl.h>
//#include <lineak/cdromctrl.h>
#include <lineak/msgpasser.h>
#include <lineak/lockctrl.h>
#include <lineak/pluginmanager.h>
#include <lineak/commandexec.h>
#include <lineak/plugin_definitions.h>

using namespace lineak_util_functions;
using namespace lineak_core_functions;
using namespace lineakd_core_functions;
using namespace std;

/** Lineakd global objects */
LKbd myKbd(null,null,null);
LConfig myConfig;
LDef myDef;
PluginManager *plugins = NULL;
Xmgr *X = 0;
CmdPrefs cmdprefs;
vector<string> macrolist;
ConfigDirectives dnd;
extern bool verbose;
extern bool global_enable;

int main(int argc, char *argv[])
{
  /** Make sure that the ~/.lineak directory exists */
  string homedir = getenv("HOME");

  /** We should be able to do this stuff w/o having an X connection */
  /* parse command line arguments */
  if ( !cmdprefs.parseArgs(argc,argv) )
       exit(false);

  verbose = cmdprefs.getVerbose();

  if (cmdprefs.showUsage()) {
       showusage(argc, argv);
       exit(true);
  }
  if (cmdprefs.showKeyboards()) {
        if (!parsedeffile(cmdprefs, myDef))
             exit(false);
        showkeyboards(myDef);
        exit(true);
  }
  
  /** Get a list of the potential plugins in the plugin directory */
  plugins = new PluginManager;
  vector<string> pluginlist = plugins->scanForPlugins();
  /** Load the plugins */
  plugins->loadPlugins(pluginlist);
  /** Define the list of macros we support */
  plugins->defineMacroLists();
  /** Define the configurate directives we support */
  plugins->defineDirectivesLists();
   /** Get a list of macros we support so that we can inform other classes */
  macrolist = plugins->getMacroList();
  /** Get a list of directives and their defaults that we support here */
  dnd = plugins->getDirectivesList();

  /** Add to the list of directives and defaults that we support implicitly. */
   dnd.addValue("KeyboardType", null);
   dnd.addValue("conffilename", null);
   dnd.addValue("CdromDevice", DEFAULT_CDROM_DEVICE);
   dnd.addValue("MixerDevice", DEFAULT_MIXER_DEVICE);
   dnd.addValue("Screensaver", null);
   dnd.addValue("Display_plugin",DEFAULT_DISPLAY_PLUGIN);
   dnd.addValue("Display_font", DISPLAY_FONT);
   dnd.addValue("Display_color", DISPLAY_COLOR);
   dnd.addValue("Display_pos", DISPLAY_POS);
   dnd.addValue("Display_align", DISPLAY_ALIGN);
   dnd.addValue("Display_timeout", DISPLAY_TIMEOUT);
   dnd.addValue("Display_hoffset", DISPLAY_HOFFSET);
   dnd.addValue("Display_voffset", DISPLAY_VOFFSET);
   dnd.addValue("Display_soffset", DISPLAY_SOFFSET);
   dnd.addValue("keystate_numlock", null);
   dnd.addValue("keystate_capslock", null);
   dnd.addValue("keystate_scrolllock", null);
 
   /** Set the macrolist for all LCommand objects */
   LCommand::setMacros(macrolist);

   /** Reconcile the directives and defaults from the plugins, with those from the
        command line. Those on the command line overwrite those specified here. */
   cmdprefs.setDefaults(dnd);

  if(cmdprefs.createNewConfig()) {
	/* read the configuration and keyboard definition file */
	if (!parsedeffile(cmdprefs, myDef))
		exit(false);
	create_new_conf(dnd, myDef);
	exit(true);
  }

// cout << "Checking locks" << endl;
// FIXME: is_running() is borked for multithreading.
  /** Make sure that we aren't already running. By default, isLocked() now calls isRunning() */
  // Right now this is broken b/c we are multithreaded. We need to fix this.
  /*
  lockCtrl lock("lineakd");
  if (lock.isLocked()) {
    	cerr << "Failed to start, lineakd is already running." << endl;
    	exit(false);
  }
  else
  	lock.lock();
  */
  /** WARINING!!! End of Displayless functions. A reference to the display required for
  		function from here on. */
  if (!X) {
   	X = new(Xmgr);
  }
  // Temporarily commeted out while tracking key bug.
  if (!X->initialized())
  	cleanexit(false);
  /** WARNING!!! From here on in, you should be using cleanexit() if you need to exit without
  		worrying about threading issues.

  		cleanexit will take care of deleting the X and myDisplay objects, as well as removing
    		the message queue and unlocking.

    		Once watch_messages is called, we should be calling do_exit() instead, to deal with
     		threading issues.

     **/
  if (!X->getDisplay()) {
   	cerr << "Could not open the display. Exiting." << endl;
   	cleanexit(false);
  }
  /** Create the users .lineak directory */
  create_homedir();
  /* everything went according to plan thisfar... some signal-handlers for cleaner exiting */
  signal(SIGTERM, signalexit);
  signal(SIGABRT, signalexit);
  signal(SIGINT, signalexit);
  /* and one so we won't have to wait() for child processes ;) */
  //signal(SIGCLD,SIG_IGN);
  signal(SIGCLD,signalchild);
  /* and for a rehash when we catch SIGHUP */
  signal(SIGHUP,signalrestart);
  /* read the configuration and keyboard definition file */
  parseConfigs(dnd, myConfig);
  /** Update the config object with any command line options. We do this again b/c the command line args trump
   *  the config file options. */
  cmdprefs.setOpts(myConfig);
  parseDefinitions(cmdprefs, myDef);
//  cout << myConfig << endl;
  /* build our EAKeyboard with the data from deffile and conffile */
  /** get the keyboard from our config file */
  myKbd = myDef.getKeyboard(myConfig["KeyboardType"]);
  /** Attempt to initialize our plugins */
  plugins->initializePlugins(myKbd, myConfig);

  if (myKbd.isEmpty()) {
   	cout << "Could not load a keyboard definition for the configured keyboard " << 	myConfig["KeyboardType"] << endl;
   	cleanexit(false);
  }
  /** Update our keyboard with our configured commands */
   myKbd.setCommands(myConfig);
   cout << myKbd;
   
   if (verbose) {
    for (map<string,LObject*>::const_iterator i = myKbd.getObjects().begin(); i != myKbd.getObjects().end(); i++) {
      LObject *m = const_cast<LObject*>(i->second);
      if (m->getType() == CODE || m->getType() == SYM) {
         LKey *key = static_cast<LKey*>(m);
	 cout << *key;
      } else if ( m->getType() == BUTTON ) {
      	 LButton *btn = static_cast<LButton*>(m);
	 cout << *btn;
      }
      else 
         cout << *m;
    }
   }
   
  /** Start the message queue */
  msgPasser messages;
  messages.start();
  /** Setup the message watching thread. This thread responds to stop and restart messages.
      From here on out, we should use do_exit() to quit the program */
  watch_messages();

  /* init X/Xkb with our EAK keycodes/keysyms */
  msg("Initializing the display");

  if (!X->initialize(myKbd)) {
     cerr << "Could not initialize all keys. Retrying.\n";
     if (!(X->initialize(myKbd))) {
     	cerr << "Retry of keyboard initialization failed. Exiting.\n";
  	do_exit();
     }
  } 

  Display* display;
  display = X->getDisplay();

  /* initialize OSD system */
  myDisplay = plugins->getDisplay(myConfig);
  if (myDisplay != NULL) {
        myDisplay->init();
  } else {
        myDisplay = new displayCtrl(myConfig);
  }
  plugins->initializePluginsDisplay(*myDisplay);

  /* alright, we're going to loop forever now. only signals can interrupt us. */
  CommandExec exec;
  exec_t execute = NULL;
  XEvent xev;
  //XKeyEvent *e;
  unsigned int numlock_mask = X->getNumlockMask();
  unsigned int scrolllock_mask = X->getScrolllockMask();
  unsigned int capslock_mask = X->getCapslockMask();
  while(1) {
	/* wait for next event */
	XNextEvent(display, &xev);
	//XNextEvent(display, &xev);
	/* Should we age the display? */
        if (myDisplay->enabled()) {
            //cout << "agenscroll()" << endl;
            myDisplay->agenscroll();
        }
        //TODO: Fix this up. Look to the main loop from xbindkeys.
        /* should we respond to this event? */
/**        if ( xev.type == KeyPress ) {
           e = (XKeyEvent *) &xev;           
           if (verbose) printf("Keycode %d pressed\n", e->keycode);
           // Check the plugins to see if they handle this. If not, send it to our internal macro handler
	   if (global_enable) {
              cout << "Getting an execute function pointer" << endl;
	      LObject *obj = myKbd.getObject((int)e->keycode);
              if (obj != NULL) {
	         cout << "Trying to find the plugin to execute this macro" << endl;
                 execute = plugins->exec(obj);
	         cout << "Trying to execute through a plugin" << endl;
                 if (execute != NULL)
                    execute(obj);
                 else {
                    if (exec.exec(obj)) {
	  	       myDisplay->show(obj->getNextToggleName());
                    }
                 }
	      } else {
		 cout << "obj is NULL for key: " << e->keycode << endl;
	      }
           }
        }
*/	
     if (global_enable) {
        switch (xev.type)
	{
	   case KeyPress:
	   {
	         
	         xev.xkey.state &= ~(numlock_mask | capslock_mask | scrolllock_mask);
	         LKey *obj = static_cast<LKey*>(myKbd.getObject((int)xev.xkey.keycode));
		 if (verbose) {
		    cout << "Key press !" << endl;
		    cout << "xev.xkey.keycode=" << xev.xkey.keycode << endl;
		    cout << "xev.xkey.state=" << xev.xkey.state << endl;
		    cout << "has modifier=" << obj->hasModifier(xev.xkey.state) << endl;
		 } 

	         if (obj != NULL) {
		    cout << "Got an object!" << endl;
	            if (obj->getType() == SYM && obj->getEventType() == PRESS) {
		       if (xev.xkey.keycode == XKeysymToKeycode (display, obj->getKeySym())
		           && obj->hasModifier(xev.xkey.state))
		       {
		          execute = plugins->exec(obj, xev);
			  //TODO: execute and exec will need to be modified to pass the
			  // xev through. Then in these functions, the correct command
			  // for the modifier will have to be chosen.
	                  if (execute != NULL)
                             execute(obj,xev);
                          else {
                             if (exec.exec(obj,xev)) {
	  	                myDisplay->show(obj->getNextToggleName());
                             }
                          }
		       }
	            }
	            else {
		        cout << "Looking for CODE and PRESS" << endl;
			
	               if (obj->getType() == CODE && obj->getEventType() == PRESS)
	               {
		          cout << xev.xkey.keycode << " = " << obj->getKeyCode() << endl;
			  
			  if (obj->hasModifier(xev.xkey.state))
			     cout << "true" << endl;
			  else
			     cout << "false" << endl;
			  
		          if (xev.xkey.keycode == obj->getKeyCode()
		              && obj->hasModifier(xev.xkey.state))
		          {
			     cout << "getting to the right place!" << endl;
			     execute = plugins->exec(obj,xev);
	                     if (execute != NULL)
                                execute(obj,xev);
                             else {
                                if (exec.exec(obj,xev)) {
	  	                   myDisplay->show(obj->getNextToggleName());
                                }
                             }
		          }
	               }
	            }
		 }
	         break;
	   } 
	   case KeyRelease:
	   {
	      /* if (verbose) {
	         cout << "Key press !" << endl;
		 cout << "xev.xkey.keycode=" << xev.xkey.keycode << endl;
		 cout << "xev.xkey.state=" << xev.xkey.state << endl;
	      } */

	      xev.xkey.state &= ~(numlock_mask | capslock_mask | scrolllock_mask);
	      LKey *obj = static_cast<LKey*>(myKbd.getObject((int)xev.xkey.keycode));
		 
	      if (obj != NULL) { 
	         if (obj->getType() == SYM && obj->getEventType() == RELEASE) {
		    if (xev.xkey.keycode == XKeysymToKeycode (display, obj->getKeySym())
		        && obj->hasModifier(xev.xkey.state)) {
		       execute = plugins->exec(obj,xev);
	               if (execute != NULL)
                          execute(obj,xev);
                       else {
                          if (exec.exec(obj,xev)) {
	  	             myDisplay->show(obj->getNextToggleName());
                          }
                       }
		    }
	         }
	         else {
	            if (obj->getType() == CODE && obj->getEventType() == RELEASE) {
		       if (xev.xkey.keycode == obj->getKeyCode()
		          && (obj->hasModifier(xev.xkey.state)))
		       {
		          execute = plugins->exec(obj,xev);
	                  if (execute != NULL)
                             execute(obj,xev);
                          else {
                             if (exec.exec(obj,xev)) {
	  	                myDisplay->show(obj->getNextToggleName());
                             }
                          }
		       }
	            }
	         }
              }
	      break;
	   } 
	   case ButtonPress:
	   {
	        /* if (verbose) {
	           cout << "Button press !" << endl;
	           cout << "xev.xbutton.button=" << xev.xbutton.button << endl;
	           cout << "xev.xbutton.state=" << xev.xbutton.state << endl;
	        } */

	        xev.xbutton.state &= ~(numlock_mask | capslock_mask | scrolllock_mask
			       | Button1Mask | Button2Mask | Button3Mask
			       | Button4Mask | Button5Mask);
	        LButton *obj = static_cast<LButton*>(myKbd.getObject((unsigned int)xev.xbutton.button));
                if (obj != NULL) {
	           if (obj->getType() == BUTTON && obj->getEventType() == PRESS) {
		      if (xev.xbutton.button == obj->getButton() && obj->hasModifier(xev.xbutton.state))
		      {
		       execute = plugins->exec(obj,xev);
	               if (execute != NULL)
                          execute(obj, xev);
                       else {
                          if (exec.exec(obj, xev)) {
	  	             myDisplay->show(obj->getNextToggleName());
                          }
                       }
		      }
		}
	     }
	     break;
           }
	   case ButtonRelease:
	   {
	     /* if (verbose) {
	        cout << "Button press !" << endl;
	        cout << "xev.xbutton.button=" << xev.xbutton.button << endl;
	        cout << "xev.xbutton.state=" << xev.xbutton.state << endl;
	     } */

	     xev.xbutton.state &= ~(numlock_mask | capslock_mask | scrolllock_mask
			       | Button1Mask | Button2Mask | Button3Mask
			       | Button4Mask | Button5Mask);
	     LButton *obj = static_cast<LButton*>(myKbd.getObject((unsigned int)xev.xbutton.button));
             if (obj != NULL) {
	     if (obj->getType() == BUTTON && obj->getEventType() == RELEASE)
		{
		  if (xev.xbutton.button == obj->getButton()
		      && obj->hasModifier(xev.xbutton.state))
		    {
	               execute = plugins->exec(obj,xev);
	               if (execute != NULL)
                          execute(obj,xev);
                       else {
                          if (exec.exec(obj,xev)) {
	  	             myDisplay->show(obj->getNextToggleName());
                          }
                       }
		    }
		}
	    }
	     break;
	  }
	  default:
	     break;
	}
     }
        if ( xev.type == MappingNotify ) {
           if (!X->xkbRemapped())
              X->xkbRemapped(true); // =1;
           else {
              msg("Reclaiming keyboard map from MappingNotify event");
              X->xkbRemapped(false);
              X->initialize(myKbd);
           }
        } 
        if (myDisplay->enabled()) {
	   //msg("age()");
           myDisplay->age();
        }
  }
  /* that's all folks.. We should never get here!!! */
  do_exit();
  return true;
}

