#include "external.h"

#include <string.h>
#include <syslog.h>
#include <fcntl.h>
#include <unistd.h>
#include <time.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include "global_vars.h"
#include "../lcp3.h"

#ifdef LPT_MONITOR

	#include <asm/io.h>

void update_lpt_status()
{
    static int previous = -1;
    struct line_t *line = (struct line_t*)lstlines.first;
    int current;
    if ( !server->lpt_status ) return;
    while ( line )
    {
	if ( !strncmp(line->linename, server->lpt_linename, LCP3_LINENAME_LEN) )
	    break;
	line = (struct line_t*)line->next;
    }
    if ( !line )
    {
	server->lpt_status = 0;
	syslog(LOG_WARNING, "No line called '%s' to monitor on lpt!", server->lpt_linename);
	return;
    }
    switch ( server->lpt_status )
    {
	case 0: return;
	case 1: // lines
	    if ( (line->con_stat == CST_UP_USER)
		|| (line->con_stat == CST_UP_SERVER) )
		current = 1;
	    else
		current = 0;
	    break;
	case 2: // clients in 2-digit HEX mode
	    current = (line->online % 16) | ((line->online / 16) << 4);
	    break;
	default: server->lpt_status = 0; return;
    }
    if ( current != previous )
    {
	previous = current;
	outb(current, server->lpt_addr);
    }
}

#endif // LPT_MONITOR

#ifdef LCD_MONITOR
/*
  Martin Berentsen < berentsen at sent5 dot uni-duisburg dot de >
  Code produces output for 16x2 or 20x2 char displays to the
  /dev/lcd device. 
  With #define LCD_16x2 you get the version 3 16x2 style,
  and with #define LCD_20x2 you get the 20x2 more system info
  style.
  version : 4
  date:     25.10.2003
*/

#ifdef LCD_20x2
void float_to_3char(float in, char *out)
{
  if (in <= 9.9)
    sprintf(out,"%3.1f",in);
  else
    sprintf(out,"%3.0f",in);
}

void uint_to_5char(unsigned int up, char *upc)
{
  if(up < 1024 ) {
    sprintf(upc,"%-4.4dB",up);
  }
  else if(up < 10229){  /* 9.99 * 1024*/
    sprintf(upc,"%-4.2fK",(float)up/1024.0);
  }
  else if(up < 102298){ /* 99.9 * 1024*/
    sprintf(upc,"%-4.1fK",(float)up/1024.0);
  }
  else if(up < 1048576){ /* 1024 * 1024*/
    sprintf(upc,"%4.0fK",(float)up/1024.0);
  }
  else if(up < (10229.8*1024)){ 
    sprintf(upc,"%-4.2fM",(float)up/(1024.0*1024.0));
  }
  else { 
    sprintf(upc,"%-4.1fM",(float)up/(1024.0*1024.0));
  }
}
#endif

void update_lcd_status()
{
  static int previous = -1;
  struct line_t *line = (struct line_t*)lstlines.first;
  int cnt = 0;
  long int current = 0;
  time_t ut = 0;	      
  char tbuf[9];
  FILE *fd;
  int cli_on = 0;
  int lines_on = 0;
#ifdef LCD_20x2
  int bla = 0;
  char buf[30];
  unsigned int up = 0;
  unsigned int down = 0;
  int ofd;
  char times[10];
  time_t mtime;
  struct tm *mmtime;
  char upc[8];
  char downc[8];
  unsigned int newest, second;
  time_t delta_t;
  char *token;
  float load;
#endif
  
  struct client_t *cur = (struct client_t*)cltlist.first;
  struct line_t *someline = (struct line_t*)lstlines.first;
  
  while( cur ) { 
    cnt++; cur = (struct client_t*)cur->next; 
  }
  
#ifdef LCD_20x2
  up = 0;
  down = 0;
#endif
  
  while( someline ) {
    cli_on+= someline->online;
    // instead of the following line one should do a
    // 'switch(someline->con_stat)' possible values are
    // listed in lcp3.h as CST_*. It might happen that
    // some function doesn't update the online member.
    // So tracking con_stat is more accurate & secure.
    // (until now no mistakes regarding the value in
    // someline->online are known, so this should work anyway.)
    
#ifdef LCD_16x2
    if(someline->online) lines_on++;
#endif
#ifdef LCD_20x2
    if(someline->online) {
      lines_on++;
      newest = someline->activity_id;
      if ( newest > 0 ) { 
	second = newest - 1; 
      } 
      else { 
	second = LCS_ACTIVITY - 1; 
      }
      delta_t = someline->activity[newest].tstamp - someline->activity[second].tstamp;
      if ( delta_t == 0 ) delta_t++;  /* avoid zero-division */
      up += (unsigned int)floor(((float)(someline->activity[newest].sent) - (float)(someline->activity[second].sent)) / (float)delta_t);
      down += (unsigned int)floor(((float)(someline->activity[newest].recvd) - (float)(someline->activity[second].recvd)) / (float)delta_t);
    }
#endif
    
    someline = (struct line_t*)someline->next; }
  
  if (cli_on > 0) {
    ut = time(NULL) - line->con_up_time; /* time in secs here */
    sprintf(tbuf,"%.4ld:%.2ld",ut/60,ut%60);
  }
  else sprintf(tbuf,"offline ");
  
#ifdef LCD_16x2  
  current = cnt+cli_on+line->online+ut;
  if ( current != previous ) {
    previous = current; 
    if((fd = fopen("/dev/lcd","w")) != NULL) {
      fprintf(fd,"\33cC:%.2d O:%.2d L:%.2d\nT:%s",cnt,cli_on,
	      lines_on,tbuf);
      fclose(fd);
    }
  }
#endif 
  
#ifdef LCD_20x2  
  
  /* getting time */
  mtime=time(NULL);
  mmtime=localtime(&mtime);
  
  /* just do thomething it tomething changes */          
  current = cnt+cli_on+line->online+ut+mmtime->tm_sec;
  if ( current != previous ) {
    previous = current;
    /* convert time -> string */
    strftime(times,255,"%H:%M.%S",mmtime);
    
    /* getting the load value */ 
    if((ofd=open("/proc/loadavg",O_RDONLY)) != 0) {
      bla=read(ofd,buf,255);
      close(ofd);
      token = strtok(buf," "); 
      load = atof(token);
      } 
    else { 
      load = 0.0;
    }        
    
    /* convert cpu-load three char */
    float_to_3char(load,buf);
    
    /* convert line-load to human readable and (B/K/M) */
    uint_to_5char(up,upc);
    uint_to_5char(down,downc);
    
    /* writing out to LCD */
    if((fd = fopen("/dev/lcd","w")) != NULL) {
      fprintf(fd,"\33c%.2d/%.2d/%.1d %s %s%s %s %s",cnt,cli_on,
	      lines_on,buf,times,upc,downc,tbuf);
      fclose(fd);
      } 
    else
      syslog(LOG_WARNING, 
	     "cannot open /dev/lcd for writing data to LCD display");
  }
#endif 
  
}
#endif
