/* $Id: event.c,v 1.4 2005/03/24 10:27:23 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* TODO: 
 * - maybe make it thread safe, add event queue and blocking/non-blocking
 *   and many other things, which can be necessary in future
 */

#include <string.h>
#include <stdlib.h>

#include "event.h"

Listener*
event_create_new_listener (void)
{
     Listener *listen = malloc (sizeof (Listener));
     if (!listen)
          return NULL;

     listen->object = NULL;
     listen->signal = NULL;
     listen->cb = NULL;
     listen->data = NULL;
     listen->next = NULL;
     return listen;
}

Listener*
event_append_listener (Listener *list, void *object, const char *signal,
                       EventCallback cb, void *data)
{
     Listener *tmp = list;
     Listener *prev = NULL;

     while (tmp)
     {
          prev = tmp;
          tmp = tmp->next;
     }
     
     tmp = event_create_new_listener ();
     if (!tmp)
          return NULL;
     tmp->object = object;
     tmp->signal = signal;
     tmp->cb = cb;
     tmp->data = data;
     tmp->next = NULL;
     
     if (!list)
          return tmp;

     if (prev)
          prev->next = tmp;

     return list;
}

Listener*
event_remove_listener (Listener *list, Listener *which)
{
     Listener *tmp = list;
     Listener *prev = NULL;
     
     while (tmp)
     {
          if (tmp == which)
          {
               if (prev)
                    prev->next = tmp->next;
               else
                    list = tmp->next;
               tmp->next = NULL;
               event_free_listener (tmp);
               break;
          }
          prev = tmp;
          tmp = tmp->next;
     }
     return list;
}

Listener*
event_remove_listener_by_object (Listener *list, void *object)
{
     Listener *tmp = list;

     while (tmp && (tmp->object != object))
          tmp = tmp->next;

     if (tmp)
          list = event_remove_listener (list, tmp);
     return list;
}

void
event_free_listener (Listener *list)
{
     Listener *tmp = list;

     while (list)
     {
          tmp = list;
          list = list->next;
          free (tmp);
     }
     return;
}

void
event_free_listener_1 (Listener *list)
{
     free (list);
     return;
}

unsigned int
event_emit_signal (Listener *list, const char *signal)
{
     unsigned int no = 0;
     while (list)
     {
          if (strncmp (list->signal, signal, strlen (list->signal)) == 0)
          {
               list->cb (list->object, list->data);
               no++;
          }
          list = list->next;
     }
     return no;
}
