/* $Id: gtkprop.c,v 1.9 2005/03/31 15:54:51 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "../li18n.h"
#include "../errors.h"
#include "hig-widgets.h"
#include "gtkdefs.h"

#include "gtkprop.h"

extern lingGtkMainWindow *main_app;

static void load_image (GtkTreeView *view, GtkWidget *image);

static void
load_image (GtkTreeView *view, GtkWidget *image)
{
     GdkPixbuf *buf = NULL;
     GError *error = NULL;
     gchar *path = NULL;
     GtkTreeIter iter;
     GtkTreeModel *model;
     GtkTreeSelection *sel = gtk_tree_view_get_selection (view);

     if (gtk_tree_selection_get_selected (sel, &model, &iter))
     {
          gtk_tree_model_get (model, &iter, 0, &path, -1);

          /* load the image into the widget */
          buf = gdk_pixbuf_new_from_file_at_size (path, 100, 100, &error);
          if (!buf)
          {
               error_warning (_("Image could not be loaded!"), error->message,
                              ERR_NOT_AVAILABLE);
               g_error_free (error);
               gtk_image_set_from_stock (GTK_IMAGE (image),
                                         GTK_STOCK_MISSING_IMAGE,
                                         GTK_ICON_SIZE_DIALOG);
          }
          else
          {
               gtk_image_set_from_pixbuf (GTK_IMAGE (image), buf);
               g_object_unref (buf);
          }
          g_free (path);
     }
     return;
}

void
gtkprop_activate (learnSession *session)
{
     GtkWidget *dlg_prop;
     GtkWidget *notebook;
     GtkWidget *lbl_general;
     GtkWidget *lbl_images;
     
     GtkWidget *tbl_meaning;
     GtkWidget *lbl_id;
     GtkWidget *lbl_id_c;
     GtkWidget *lbl_lesson;
     GtkWidget *lbl_lesson_c;
     GtkWidget *lbl_lesson_path;
     GtkWidget *lbl_lesson_path_c;
     
     GtkWidget *box_images;
     GtkWidget *scr_win;
     GtkWidget *view_image;
     GtkListStore *list_image;
     GtkTreeIter iter;
     GtkCellRenderer *renderer;
     int i = 0;

     GtkWidget *frm_preview;
     GtkWidget *align;
     GtkWidget *image;

     gchar *text = NULL;
     lingMeaning *meaning = NULL;
     lingchar **images = NULL;

     /* create the meaning stuff */
     meaning = ling_meaning_get_by_id (session->cur_entry->lesson->lesson,
                                       session->cur_entry->id,
                                       session->language->language);
     /* note to translators: the text will read as: Meaning 123: Properties */
     text = g_strdup_printf ("%s %i: %s", _("Meaning"), meaning->id,
                             _("Properties"));
     dlg_prop = gtk_dialog_new_with_buttons (text,
                                             GTK_WINDOW (main_app->window),
                                             GTK_DIALOG_MODAL |
                                             GTK_DIALOG_DESTROY_WITH_PARENT,
                                             GTK_STOCK_CLOSE,
                                             GTK_RESPONSE_CLOSE,
                                             NULL);
     g_free (text);
     gtk_window_set_resizable (GTK_WINDOW (dlg_prop), FALSE);
     gtk_container_set_border_width (GTK_CONTAINER (dlg_prop), WIDGET_BORDER);
     gtk_dialog_set_has_separator (GTK_DIALOG (dlg_prop), FALSE);

     notebook = gtk_notebook_new ();
     gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dlg_prop)->vbox), notebook,
                         TRUE, TRUE, 0);
     gtk_container_set_border_width (GTK_CONTAINER (notebook), WIDGET_BORDER);
     
     lbl_general = gtk_label_new (_("General"));
     tbl_meaning = hig_table_new (3, 2);
     gtk_notebook_append_page (GTK_NOTEBOOK (notebook), tbl_meaning,
                               lbl_general);

     /* meaning id */
     text = g_strdup_printf (MARKUP_BOLD, _("Id:"));
     lbl_id = gtk_label_new (NULL);
     gtk_label_set_markup (GTK_LABEL (lbl_id), text);
     gtk_misc_set_alignment (GTK_MISC (lbl_id), 1, 0.5);
     gtk_table_attach (GTK_TABLE (tbl_meaning), lbl_id, 0, 1, 0, 1,
                       GTK_FILL, GTK_FILL, 0, 0);
     g_free (text);
     
     text = g_strdup_printf ("%i", session->cur_entry->id);
     lbl_id_c = gtk_label_new (text);
     gtk_misc_set_alignment (GTK_MISC (lbl_id_c), 0, 0.5);
     gtk_table_attach (GTK_TABLE (tbl_meaning), lbl_id_c, 1, 2, 0, 1,
                       GTK_FILL, GTK_FILL, 0, 0);
     g_free (text);

     /* lesson name */
     text = g_strdup_printf (MARKUP_BOLD, _("Lesson type:"));
     lbl_lesson = gtk_label_new (NULL);
     gtk_label_set_markup (GTK_LABEL (lbl_lesson), text);
     gtk_misc_set_alignment (GTK_MISC (lbl_lesson), 1, 0.5);
     gtk_table_attach (GTK_TABLE (tbl_meaning), lbl_lesson, 0, 1, 1, 2,
                       GTK_FILL, GTK_FILL, 0, 0);
     g_free (text);

     lbl_lesson_c = gtk_label_new (session->cur_entry->lesson->lesson->type);
     gtk_misc_set_alignment (GTK_MISC (lbl_lesson_c), 0, 0.5);
     gtk_table_attach (GTK_TABLE (tbl_meaning), lbl_lesson_c, 1, 2, 1, 2,
                       GTK_FILL, GTK_FILL, 0, 0);

     /* lesson path */
     text = g_strdup_printf (MARKUP_BOLD, _("Lesson path:"));
     lbl_lesson_path = gtk_label_new (NULL);
     gtk_label_set_markup (GTK_LABEL (lbl_lesson_path), text);
     gtk_misc_set_alignment (GTK_MISC (lbl_lesson_path), 1, 0.5);
     gtk_table_attach (GTK_TABLE (tbl_meaning), lbl_lesson_path, 0, 1, 2, 3,
                       GTK_FILL, GTK_FILL, 0, 0);
     g_free (text);

     text = ling_lesson_get_path (session->cur_entry->lesson->lesson);
     lbl_lesson_path_c = gtk_label_new (text);
     gtk_misc_set_alignment (GTK_MISC (lbl_lesson_path_c), 0, 0.5);
     gtk_table_attach (GTK_TABLE (tbl_meaning), lbl_lesson_path_c, 1, 2, 2, 3,
                       GTK_FILL, GTK_FILL, 0, 0);

     /* image list */
     box_images = hig_vbox_new ();
     lbl_images = gtk_label_new (_("Images"));
     gtk_notebook_append_page (GTK_NOTEBOOK (notebook), box_images,
                               lbl_images);

     list_image = gtk_list_store_new (1, G_TYPE_STRING);
     images = ling_meaning_get_images (meaning);
     if (images)
     {
          for (i = 0; images[i]; i++)
          {
               gtk_list_store_append (list_image, &iter);
               gtk_list_store_set (list_image, &iter, 0, images[i], -1);
          }
          ling_strings_free (images);

     }
     view_image = gtk_tree_view_new_with_model (GTK_TREE_MODEL (list_image));
     g_object_unref (list_image);

     renderer = gtk_cell_renderer_text_new ();
     gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (view_image),
                                                  0, _("Image"),
                                                  renderer, "text", 0, NULL);
     scr_win = hig_scrolled_window_new ();
     gtk_container_set_border_width (GTK_CONTAINER (scr_win), 0);
     gtk_container_add (GTK_CONTAINER (scr_win), view_image);
     gtk_box_pack_start (GTK_BOX (box_images), scr_win, FALSE, TRUE, 0);

     frm_preview = hig_frame_new (_("Preview"));
     gtk_container_set_border_width (GTK_CONTAINER (frm_preview), 0);
     align = gtk_bin_get_child (GTK_BIN (frm_preview));
     image = gtk_image_new_from_stock (GTK_STOCK_MISSING_IMAGE,
                                       GTK_ICON_SIZE_DIALOG);
     gtk_container_add (GTK_CONTAINER (align), image);
     gtk_box_pack_start (GTK_BOX (box_images), frm_preview, TRUE, TRUE, 0);

     ling_meaning_free (meaning);

     /* connect the changed signal for the image */
     g_signal_connect (G_OBJECT (view_image), "cursor-changed",
                       G_CALLBACK (load_image), image);

     gtk_widget_show_all (notebook);
     gtk_dialog_run (GTK_DIALOG (dlg_prop));
     gtk_widget_destroy (dlg_prop);

     return;
}
