/* $Id: learn.h,v 1.11 2005/03/24 10:27:23 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * TODO: create session load/save functions
 */

#ifndef LING_LEARN_H
#define LING_LEARN_H 1

#include <lingoteach.h>

typedef struct _learnLanguage learnLanguage;
struct _learnLanguage
{
     lingchar      *language; /* pointer to the language */
     lingbool       used;     /* is the language used */
     lingbool       main;     /* is it the main language */
     learnLanguage *next;     /* pointer to next */
     learnLanguage *prev;     /* pointer to previous */
};

typedef enum 
{
     RANDOM,
     SEQUENCE,
     REVIEW,
     LEARN
} learnMethodType;

learnLanguage*
learn_language_init_new (void);

learnLanguage*
learn_language_append_language (learnLanguage *lang, lingchar *language,
                                lingbool used, lingbool main);

void
learn_language_change_main_language (learnLanguage *lang, lingchar *language);

void
learn_language_use_language (learnLanguage *lang, lingchar *language,
                             lingbool used);

void
learn_language_free (learnLanguage *lang);


typedef struct _learnLesson learnLesson;
struct _learnLesson
{
     lingLesson     *lesson; /* the lesson used for learning */
     unsigned int    amount; /* the amount of meanings to learn */
     unsigned int    start;  /* the start value to choose ids from */
     unsigned int    end;    /* the max. value  to choose ids from */
     learnMethodType access; /* access method */
     learnLesson    *next;   /* pointer to the next lesson */
     learnLesson    *prev;   /* pointer to the previous lesson */
};

learnLesson*
learn_lesson_new (void);

learnLesson*
learn_lesson_append_lesson (learnLesson *learn_lesson, lingLesson *lesson,
                            unsigned int amount, unsigned int start,
                            unsigned int end, learnMethodType type);

learnLesson*
learn_lesson_remove_lesson (learnLesson *learn_lesson, lingLesson *lesson);

void
learn_lesson_free (learnLesson *lesson);

typedef struct _learnEntry learnEntry;
struct _learnEntry
{
     learnLesson  *lesson; /* the lesson, the entry comes from */
     unsigned int  id;     /* the meaning id in the lesson */
     learnEntry   *next;   /* pointer to next entry */
     learnEntry   *prev;   /* pointer to previous entry */
};

learnEntry*
learn_entry_new (void);

learnEntry*
learn_entry_append_entry (learnEntry *entry, learnLesson *lesson,
                          unsigned int id);

learnEntry*
learn_entry_create_from_lesson (learnLesson *lesson);

void
learn_entry_free (learnEntry *entry);

typedef struct
{
     char          *file;      /* the file name the session was loaded from */
     learnLesson   *lessons;   /* the lessons to learn from */
     learnLanguage *language;  /* the languages to use */
     learnEntry    *entry;     /* the various entries for the session */
     lingbool       hints;     /* flag for additional hints in the session */
     learnEntry    *cur_entry; /* pointer to current (shown) entry */
} learnSession;

learnSession*
learn_session_new (void);

void
learn_session_free (learnSession *session);

learnSession*
learn_session_load (char *file, lingConfig *config, lingchar **languages,
                    lingLesson **list);

lingbool
learn_session_save (learnSession *session, char *file);

lingbool
learn_session_check_lesson (learnSession *session, lingLesson *lesson);

int
learn_random_no (unsigned int max);

#endif  /* LING_LEARN_H */
