/*  This file is part of LingoTeach, the Language Teaching program 
 *  Copyright (C) 2001-2003 The LingoTeach Team
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *  GNU General Public License for more details. 
 * 
 *  You should have received a copy of the GNU General Public License 
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#include <stdlib.h>
#include <gtk/gtk.h>

#include "filter.h"
#include "lingoteach-i18n.h"

static gchar *filters[] =
  {
    "KVocTrain", NULL
  };
static GtkWidget *opt_filter;

const gint   module_type (void);
const gchar* module_name (void);
const gchar* module_desc (void);
GtkWidget*   module_box  (void);
GtkWidget*   module_info (void);
void         module_free (void);
static GtkWidget* create_menu (void);
static void use_filter (GtkOptionMenu *optionmenu);
static void invoke_filter (GtkEntry *text);




static 
GtkWidget* create_menu (void)
{
  GtkWidget* menu;
  GtkWidget* mitem;
  gint i = 0;
  
  menu = gtk_menu_new ();
  
  while (filters[i] != NULL)
    {
      mitem = gtk_menu_item_new_with_label (filters[i]);
      gtk_widget_show (mitem);
      gtk_menu_shell_append  ((GtkMenuShell *)(menu), mitem);
      i++;
    }
  gtk_menu_set_active (GTK_MENU (menu), 0);
  return menu;

}

static 
void use_filter (GtkOptionMenu *optionmenu)
{

  return;
}

static 
void invoke_filter (GtkEntry *text)
{
  lingMeaning *meaning;
  gchar *t = gtk_entry_get_text (text);
  gint   i = gtk_option_menu_get_history (GTK_OPTION_MENU (opt_filter));
  
  switch (i)
    {
    case 0: /* KVocTrain */
      meaning = filter_kvoc (t);
      break;
    default:
      meaning = NULL;
      break;
    }

  return;
}

/*
 * public members start here 
 */

const gint 
module_type (void)
{
  /* it is for the search tab */
  return 2; /* SEARCH */
}

const gchar* 
module_name (void)
{
  return "Data Filter";
}

const gchar* 
module_desc (void)
{
  return _("Im- and export filter for LingoTeachs Lessons and third party data");
}

GtkWidget*
module_box (void)
{
  GtkWidget *box_main;
  GtkWidget *lbl_filter;
  GtkWidget *men_filter;
  GtkWidget *txt_filter;
  GtkWidget *btn_import;

  box_main   = gtk_hbox_new (FALSE, 2);
  lbl_filter = gtk_label_new (_("Application:"));
  btn_import = gtk_button_new_with_mnemonic (_("_Import"));
  opt_filter = gtk_option_menu_new ();
  men_filter = create_menu ();
  txt_filter = gtk_entry_new ();
  gtk_option_menu_set_menu (GTK_OPTION_MENU (opt_filter), men_filter);
  
  gtk_box_pack_start (GTK_BOX (box_main), lbl_filter, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (box_main), opt_filter, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (box_main), txt_filter, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (box_main), btn_import, FALSE, FALSE, 0);

  /* signals */
  g_signal_connect_swapped (G_OBJECT (btn_import), "clicked",
			    G_CALLBACK (invoke_filter), txt_filter);

  gtk_widget_show_all (box_main);
  
  return box_main;
}

GtkWidget*
module_info (void)
{
  GtkWidget *box_main;
  GtkWidget *lbl_descr;
  
  lbl_descr = gtk_label_new (_("This is a filter module for the\n"
			       "Search and Browse notebook page"));
  box_main = gtk_vbox_new (TRUE, 2);

  gtk_box_pack_start (GTK_BOX (box_main), lbl_descr, FALSE, FALSE, 0);
  
  gtk_widget_show_all (box_main);
  return box_main;
}

void 
module_free (void)
{
  return;
}
