/*  This file is part of LingoTeach, the Language Teaching program *
 *  Copyright (C) 2001-2003 The LingoTeach Team
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version.  
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *  GNU General Public License for more details.  
 *
 *  You should have received a copy of the GNU General Public License 
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#include <string.h>
#include <glib/gprintf.h>


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "lingoteach-i18n.h"
#include "errors.h"
#include "learningpref.h"
#include "util.h"
#include "about.h"

extern struct lpreferences genLprefs; /* preferences */


/* prototypes */
GtkWidget* create_dlg_about (void);
void open_link (const gchar *link);


/*********************
 * private functions *
 *********************/

GtkWidget*
create_dlg_about (void)
{
  GtkWidget *dlg_about;
  GtkWidget *box_about_dlg;
  GtkWidget *box_about;
  GtkWidget *lbl_about;
  GtkWidget *btn_about;
  GtkWidget *notebook_about;
  GtkWidget *scr_win_team;
  GtkWidget *text_view_team;
  GtkWidget *lbl_team;
  GtkWidget *scr_win_license;
  GtkWidget *text_view_license;
  GtkWidget *lbl_license;
  GtkWidget *dlg_about_action;
  GtkWidget *button2;

  GtkTextBuffer *buf_credits;
  GtkTextBuffer *buf_license;
  
  /* text stuff */
  char   *basefile;
  char   *buf;
  int     n;
  GError *err = NULL;

  dlg_about = gtk_dialog_new ();
  gtk_widget_set_size_request (dlg_about, 340, 304);
  gtk_window_set_title (GTK_WINDOW (dlg_about), _("About"));
  gtk_window_set_modal (GTK_WINDOW (dlg_about), TRUE);

  box_about_dlg = GTK_DIALOG (dlg_about)->vbox;

  box_about = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (box_about_dlg), box_about, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (box_about), 4);

  lbl_about = gtk_label_new (_(PACKAGE_NAME" v" VERSION " - " INTVERSION
			       "\nA language teaching program\n"
			       "Copyright (C) 2001-2003 by \n"
			       "The LingoTeach Team"));
  gtk_label_set_justify (GTK_LABEL (lbl_about), GTK_JUSTIFY_CENTER);
  gtk_box_pack_start (GTK_BOX (box_about), lbl_about, FALSE, FALSE, 7);

  btn_about = gtk_button_new_with_label ("http://www.lingoteach.org");
  gtk_box_pack_start (GTK_BOX (box_about), btn_about, FALSE, FALSE, 6);

  notebook_about = gtk_notebook_new ();
  gtk_box_pack_start (GTK_BOX (box_about), notebook_about, TRUE, TRUE, 0);

  scr_win_team = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_add (GTK_CONTAINER (notebook_about), scr_win_team);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scr_win_team), 
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  text_view_team = gtk_text_view_new ();
  gtk_container_add (GTK_CONTAINER (scr_win_team), text_view_team);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (text_view_team), FALSE);
  gtk_text_view_set_pixels_above_lines (GTK_TEXT_VIEW (text_view_team), 1);
  gtk_text_view_set_left_margin (GTK_TEXT_VIEW (text_view_team), 15);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (text_view_team), FALSE);

  /* fill the text view */
  buf_credits = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text_view_team));
  basefile    = g_build_filename (DATADIR, "AUTHORS", NULL);

  if (g_file_get_contents (basefile, &buf, &n, &err) == FALSE)
    {
      err_error_cb (err->message);
      g_error_free (err);
    }
  
  /* fill the credit buffer */
  gtk_text_buffer_set_text (buf_credits, buf, n);
  g_free (buf);
  g_free(basefile);

  lbl_team = gtk_label_new (_("Team"));
  gtk_notebook_set_tab_label 
    (GTK_NOTEBOOK (notebook_about), 
     gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook_about), 0), 
     lbl_team);
  gtk_label_set_justify (GTK_LABEL (lbl_team), GTK_JUSTIFY_LEFT);

  scr_win_license = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_add (GTK_CONTAINER (notebook_about), scr_win_license);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scr_win_license), 
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  text_view_license = gtk_text_view_new ();
  gtk_container_add (GTK_CONTAINER (scr_win_license), text_view_license);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (text_view_license), FALSE);
  gtk_text_view_set_pixels_above_lines (GTK_TEXT_VIEW (text_view_license), 1);
  gtk_text_view_set_left_margin (GTK_TEXT_VIEW (text_view_license), 15);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (text_view_license), FALSE);

  /* fill the license view */
  buf_license = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text_view_license));
  basefile = g_build_filename (DATADIR, "COPYING", NULL);
  if (g_file_get_contents (basefile, &buf, &n, &err) == FALSE)
    {
      err_error_cb (err->message);
      g_error_free (err);
    }
  
  /* fill the license buffer */
  gtk_text_buffer_set_text (buf_license, buf, n);
  g_free (buf);
  g_free(basefile);

  lbl_license = gtk_label_new (_("License"));
  gtk_notebook_set_tab_label 
    (GTK_NOTEBOOK (notebook_about), 
     gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook_about), 1), 
     lbl_license);
  gtk_label_set_justify (GTK_LABEL (lbl_license), GTK_JUSTIFY_LEFT);

  dlg_about_action = GTK_DIALOG (dlg_about)->action_area;
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dlg_about_action), 
			     GTK_BUTTONBOX_END);

  button2 = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
  gtk_dialog_add_action_widget (GTK_DIALOG (dlg_about), button2, 
				GTK_RESPONSE_CLOSE);
  GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);

  g_signal_connect_swapped (G_OBJECT (btn_about), "clicked",
			    G_CALLBACK (open_link), 
			    "http://www.lingoteach.org");

  gtk_widget_show_all (GTK_DIALOG (dlg_about)->vbox);
  return dlg_about;
}

/* 
 * opens the passed link with the defined browser 
 */
void open_link (const gchar *link)
{
  gchar  *cmd;
  GError *err;

  if (genLprefs.browser != NULL)
    {
      cmd = g_malloc (strlen (genLprefs.browser) + strlen (link));
      g_sprintf (cmd, "%s %s", genLprefs.browser, link);
      if (!g_spawn_command_line_async (cmd, &err))
	err_error_cb (err->message);
      g_free (cmd);
    }
  return;
}


/*********************
 * public functions *
 *********************/

void
on_info1_activate (void)
{
  GtkWidget *about;
  gint       result;

  about  = create_dlg_about ();
  result = gtk_dialog_run (GTK_DIALOG (about));
  switch (result)
    {
    default:
      gtk_widget_destroy (about);
      break;
    }
  return;
}
