/* This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2001-2003 The LingoTeach Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "lingoteach-i18n.h"
#include "errors.h"

/**
 * error window with the message [data]
 */
void
err_error_cb (gchar* data)
{
  GtkWidget* error_dialog;

#ifdef DEBUG
  printf (_("ERROR_CB: %s \n"), data);
#endif

  error_dialog = gtk_message_dialog_new (NULL,
                                         GTK_DIALOG_DESTROY_WITH_PARENT,
                                         GTK_MESSAGE_WARNING,
                                         GTK_BUTTONS_CLOSE,
                                         data);
  gtk_window_set_position (GTK_WINDOW (error_dialog), GTK_WIN_POS_CENTER);
  gtk_dialog_run (GTK_DIALOG (error_dialog));
  gtk_widget_destroy (error_dialog);

  return;
}

/**
 * critical error window with the message [data]
 */
void
err_critical_cb (gchar* data)
{
  GtkWidget* crit_dialog;

#ifdef DEBUG
  printf (_("CRIT_CB: %s \n"), data);
#endif

  crit_dialog = gtk_message_dialog_new (NULL,
                                        GTK_DIALOG_DESTROY_WITH_PARENT,
                                        GTK_MESSAGE_ERROR,
                                        GTK_BUTTONS_CLOSE,
                                        data);
  gtk_window_set_position (GTK_WINDOW (crit_dialog), GTK_WIN_POS_CENTER);
  gtk_dialog_run (GTK_DIALOG (crit_dialog));
  gtk_widget_destroy (crit_dialog);
  return;
}

