/*  This file is part of LingoTeach, the Language Teaching program 
 *  Copyright (C) 2001-2003 The LingoTeach Team
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *  GNU General Public License for more details. 
 * 
 *  You should have received a copy of the GNU General Public License 
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#ifndef LING_LPREF_H
#define LING_LPREF_H 1

#include <gtk/gtk.h>
#include <lingoteach.h>

/* general preferences for lingoteach */
struct lpreferences
{
  gchar  *soundpath;  /* sound path */
  gchar  *browser;    /* standard browser */
  gchar  *mlanguage;  /* main language to use */
  gchar **languages;  /* list of languages to use */
  gchar  *player;     /* a sound player with necessary args */
  Method  method;     /* learning method */
};

/* for our lesson list view */
enum 
  {
    LESSON_NAME,
    LESSON_PATH,
    CURR_USED,
    NUMBER
  };

void
on_preferences1_activate (void);

lingbool
read_config (void);

void 
create_config (void);

#endif /* LING_LPREF_H */
