/*  This file is part of LingoTeach, the Language Teaching program 
 *  Copyright (C) 2001-2003 The LingoTeach Team
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *  GNU General Public License for more details. 
 * 
 *  You should have received a copy of the GNU General Public License 
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <lingoteach.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "lingoteach-i18n.h"
#include "gui.h"
#include "learningpref.h"

extern lingConfig *settings;
extern struct lpreferences genLprefs;

int
main (int argc, char* argv[])
{
  GtkWidget *window;
  gchar     *langfile;

  if (!g_thread_supported ()) 
    g_thread_init (NULL);

  g_set_prgname ("LingoTeach");

#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, LOCALEDIR);
  bind_textdomain_codeset (PACKAGE, "UTF-8");
  textdomain (PACKAGE);
#endif

  gdk_threads_init ();
  gtk_init (&argc, &argv);
  
  /* initialize application and library params */
  langfile = g_build_filename (DATA_PATH, "language.xml", NULL);
  if ((settings = ling_conf_init_config ()) == NULL)
    return 1;

  settings = ling_conf_set_app_name (settings, "lingoteach");
  settings = ling_conf_set_lang_file (settings, langfile);
  g_free (langfile);

  genLprefs.mlanguage = NULL;
  genLprefs.languages = NULL;
  genLprefs.soundpath = NULL;
  genLprefs.browser = NULL;
  genLprefs.player = NULL;
  genLprefs.method = RANDOM;

  if (!read_config ())
    create_config ();

  /* create window and start the application */
  window = create_win_main ();
  gtk_widget_show (window);
  gtk_main ();

  return 0;
}
