/*  This file is part of LingoTeach, the Language Teaching program *
 *  Copyright (C) 2001-2003 The LingoTeach Team
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version.  
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *  GNU General Public License for more details.  
 *
 *  You should have received a copy of the GNU General Public License 
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#ifndef LING_SEARCH_H
#define LING_SEARCH_H 1

#include <gtk/gtk.h>

enum 
  {
    M_ID,
    M_TYPE,
    M_LANG,
    M_TRANS,
    M_NUMBER
  };

void 
on_tree_sab_expand (GtkTreeView *tree, GtkTreeIter *iter);


void
on_txt_sab_filter_activated (GtkEntry *entry, GtkOptionMenu *option);


void 
on_opt_sab_files_changed (GtkOptionMenu *optionmenu);

void
on_btn_sab_refresh_clicked (GtkOptionMenu *optionmenu);

void 
on_btn_sab_save_clicked (GtkOptionMenu *optionmenu);

void
on_btn_sab_saveas_clicked (void);

void
on_btn_sab_add_clicked (GtkTreeView *tree);

void
on_btn_sab_remove_clicked (GtkTreeView *tree);

void
on_btn_sab_edit_clicked (GtkTreeView *tree);

void
on_btn_process_stop_clicked (GtkButton *button);

GtkWidget*
sab_make_menu (void);

GtkTreeStore*
get_sab_list (void);


#endif /* LING_SEARCH_H */
