#ifndef __editor_h__
#define __editor_h__

#include "define.h"
#include "dialog.h"
#include "keybind.h"
#include "mlslocale.h"
#include "editorclipboard.h"
#include "strutil.h"

using namespace std;

namespace MLS
{

struct LineInfo
{
	int		nTextLine;		/// Text Position
	int		nViewLine;		/// screen view position
	int		nNextLineNum;	/// 한 라인을 넘어 서는 경우에 라인 위치
	bool	bNext;			/// 한 라인을 넘어섰는가?
	wstring	sWString;		/// wstring
};

struct EditSelect
{
	int	x1;  int	y1; /// select first position(x,y)
	int x2;	 int	y2; /// select last position (x,y)
};

enum EditMode
{
	EDIT,			/// Edit Mode
	SELECT,			/// Select Mode
	BLOCK,			/// Block Select Mode
	SHIFT_SELECT	/// Shift Mode
};

class Editor
{
	int				_height;			/// screen height
	int				_width;				/// screen width
	int				_nLine;				/// text screen line size
	int				_nCulumn;			/// text screen culumn size
	int				_nCurCulumn_Max; 	/// max culumn position

	int				_nFirstLine;		/// screen line first position
	int				_nLastLine;			/// screen line last postion
	string::size_type 	_nViewCul;		/// view culumn size
	int					_nViewLine;		/// view line size
	
	int					_nCurLine;		/// current line position
	string::size_type	_nCurCulumn;	/// current culumn position
	
	bool			_bLineNumView;	/// Line Number View
	bool			_bInsert; 		/// Insert mode
	bool			_bIndentMode;	/// Indentation mode (들여쓰기 모드)

	EditorClipboard	_Clip;			
	EditMode		_EditMode;		/// edit mode
	EditSelect		_EditSelect;	/// Select X,Y value
	
	int				_nLineWidth; 	/// line number size
	int				_nTabSize;		/// tab size
	
	bool			_shutdown;		/// exit value
	bool			_bReadOnly;		/// ReadOnly value
	bool			_bDosMode;		/// DosMode
	bool			_bKeyCfgLoad;	/// key file load

	string			_title;			/// title
	string			_sFile;			/// file
	bool			_bBackup;		/// backup 여부
	ENCODING		_eEncode;		/// current load file encoding code value
	int				_nConvInfo;		/// Save 지점 변경 위치 저장 (_vDoInfo 사이즈 참조)

	// find 관련
	wstring			_sFindStr;
	int				_nFindPosX;
	int				_nFindPosY;

	vector<LineInfo>	_vViewString;
	vector<wstring>		_vText;			/// wstring vector
	vector<DoInfo*>		_vDoInfo;		/// vector for Undo

	KeyBind			_tEditKeyBind;
	WINDOW*			_editorwin;

	/// Function List
	void 	ScreenMemSave(int nLine, int nCulumn);

	void	SelectionDraw(const wstring& sViewWStr, int nY, int nN, int x1, int x2);
	void 	LineDraw(	const wstring&	sViewStr,
						int nY, 
						int nN, 
						int nLineNum,   // 현재 라인 위치
						int nNum);      // 줄바뀜 번호
	void	CurserDraw(int nY, int nN);
	void	Draw(bool bBool = true);
	void	DrawEtc();

	void	InputData(const string& sKrStr);

	void	SelectSort(EditSelect*	pEditSelect);
	void	Selected_Del();

public:
	Editor(const string& sTitle = "", int height = g_nLINES, int width = g_nCOLS);
	~Editor();

	void	Init();
	bool 	KeyLoad(const string& sKeyFile);
	bool	isKeyCfgLoad() { return _bKeyCfgLoad; }

	int		Resize(int height = g_nLINES, int width = g_nCOLS)
	{
		_height = height; _width = width;
	}
	
	void	SetTitle(const string& sStr = "") { _title = sStr; }
	void	SetEditor(int nTabSize = 8, bool bBackup = false, bool bLineNumView = false);
	
	void 	New(const string& sFile);
	bool	Load(const string& sFile, bool bReadOnly = false);
	bool	Save(const string& sFile, ENCODING	Encode, bool bDosMode = false, bool bBackup = false);

	int		Do();
		
	/********************************************/
	/* 명령어 */
	void	LineNumberView() 
	{ 
		_bLineNumView = !_bLineNumView;
	}

	void	Key_Left();
	void	Key_Right();
	void	Key_Up();
	void	Key_Down();

	void	Key_ShiftLeft();
	void	Key_ShiftRight();
	void	Key_ShiftUp();
	void	Key_ShiftDown();

	void	Key_Ins() { _bInsert = !_bInsert; }
	void	Key_Del();
	void	Key_BS();
	void	Key_Tab();
	void	Key_Untab();

	void	IndentMode()	{ _bIndentMode = !_bIndentMode; }
	bool	GetIndentMode()	{ return _bIndentMode; }

	void	Key_Home();
	void	Key_End();
	void	Key_PgUp();
	void	Key_PgDn();	

	void	Key_Enter();
	void	Key_Mouse();

	void	GotoLine();
	void	GotoFirst();
	void	GotoEnd();

	void	Menu();	
	void	Refresh();

	void	Copy();
	void	Cut();
	void	Paste();
	void	Undo();

	void	Key_ESC();

	void	Select();
	void	SelectAll();
	void	BlockSelect();

	void	FileNew();
	void	FileSave();
	void	FileSaveAs();
	void	Exit();

	void	Find();
	void	FindNext();
	void	FindPrevious();

	void	Help();
	void	About();
};

extern Editor* g_pEditor;
};

#endif

