///	\file	Mcd.cpp
///	\brief	Mcd.cpp
#include "Mcd.h"

using namespace std;
using namespace MLS;
using namespace strutil;

Mcd::
Mcd(string		sDir, const char *_title)
{
	m_sTitle = _title;
	m_pRoot = NULL;
	m_nSRow = 0;
	m_nSCol = 0;
	m_sInfofile = config.GetValue("cfghome") +"treeinfo";
	m_sCode = "MLS2";
	m_nCounter = 0;
}

///	\brief	소멸자
Mcd::~Mcd()
{
	if (m_pRoot)
	for (pDirIterator p = m_pOrder.begin(); p!=m_pOrder.end(); ++p)
		delete *p;
	wrefresh(win);
	if (win) delwin(win);
	refresh();
	m_nCounter = 0;
}

///	\brief	tree 이하의 노드를 모두 지운다.
///	\param	tree		지우고자 하는 자식 노드
///	\param	bOrdering 	정렬 여부
void Mcd::destroy(dir *tree, bool bOrdering)
{// 비재귀	
	if (tree==NULL) return;
	if (m_pOrder.empty()) return;
	
	int depth = tree->depth;
	
	for (pDirIterator i=m_pOrder.begin()+tree->index+1; i!=m_pOrder.end(); i++)
	{
		if (depth >= (*i)->depth) break;
		delete *i;
	}
	tree->node.clear();
	tree->bCheck = false;
	
	if (bOrdering) 
	{
		setOrder();
	}
	
	/* 재귀판
	if (!tree) return;
	for (pDirIterator i=tree->node.begin(); i!=tree->node.end(); i++)
		destroy((*i));
	
	delete tree;
	tree=NULL;*/
}

///	\brief	파일에서 tree 정보를 load한다.
///	\return	0	:	성공.\n
///			1	:	실패
int Mcd::load()
{
	dir		*pNode = NULL;
	dir		*preNode = NULL;
	int		size, depth, preDepth=0, row=0;
	FILE	*fp;
	char	*name;
	char	head[5];
	bool	linked;
	bool	bDirNotNull;
	int		nCheck;
	
	fp = fopen(m_sInfofile.c_str(), "rb");
		
	if (!fp) return ERROR;

	fgets(head, 5, fp);
	if (strcmp(head, m_sCode)) return ERROR;
	
	while(!feof(fp))
	{
		depth=fgetc(fp);
		
		int links = fgetc(fp);
		
		if (links == 1) 
            linked = true;
		else 
            linked = false;
			
		nCheck = fgetc(fp);
		
		size =fgetc(fp)*256;
		size +=fgetc(fp);
		
		if (feof(fp)) break;
		
		name = new char[size+1];
		memset(name, 0, size+1);
		fread(name, size, 1, fp);
		
		// depth에 따른 노드 조정
		if (depth > preDepth)
		{
			pNode = preNode;
		}
		else
		{
			while(depth < preDepth)
			{
				pNode = pNode->parent;
				preDepth--;
			}
			if (pNode) row++;
		}
	
		preNode = new dir(name ,pNode, links, linked);
		preNode->row = row;
		if (nCheck == 1)
			preNode->bCheck = true;
		else
			preNode->bCheck = false;
		
		delete []name;
		
		if (pNode) pNode->node.push_back(preNode);
		else pNode = preNode;
		
		preDepth = depth;
	}
	
	fclose(fp);
	
	if (pNode != NULL)
	{
		while(pNode->parent)
			pNode=pNode->parent;
        
		m_pRoot=pNode;
	}
	else
	{
		return ERROR;
	}

	setOrder();
	return SUCCESS;
}

///	\brief	파일에 tree정보를 저장한다.
///	\return	0을 반환
int Mcd::save()
{
	FILE *fp = fopen(m_sInfofile.c_str(), "wb");

	if (!fp) return ERROR;
	
	fwrite(m_sCode, 4, 1, fp);
	
	for (pDirIterator i = m_pOrder.begin(); i!= m_pOrder.end(); i++)
	{	
		fputc ((*i)->depth, fp);
		
		if ((*i)->linked) 
			fputc (1, fp);
		else 
			if ((*i)->nlink > 2) 
				fputc(3, fp);
			else 
				fputc(0, fp);
		
		if ((*i)->bCheck == false)
			fputc (0, fp);
		else
			fputc (1, fp);
				
		fputc ((*i)->name.size() / 256, fp);
		fputc ((*i)->name.size() % 256, fp);
		fputs ((*i)->name.c_str(), fp);
	}
	
	fclose(fp);
	return SUCCESS;
}

///	\brief	현재 directory의 Full directory명을 얻는다.
///	\return	현재 directory의 Full directory명
string &
Mcd::dir::path()
{
	static pDirContainer st;
	static std::string p;
	dir *pNode=this;
	
	p.erase();
	st.clear();
	
	while(pNode->parent != NULL)
	{
		st.push_back(pNode);
		pNode= pNode->parent;
	}
	
	p = pNode->name;
	
	while(!st.empty())
	{
		p += st.back()->name;
		p += '/';
		st.pop_back();				
	}
	
	return p;
}

///	\brief	str과 같은 directory를 찾는다.
///	\return	-1	:	찾지 못했음
///			양수:	찾은 index
int 
Mcd::Search(const string &str, int nNextNum)
{
	pDirIterator i=m_pOrder.begin(), end=m_pOrder.end();	
	string p=tolower(str);

	int nCount = 0;
	
	while(i != end)
	{
		Mcd::dir &rd = *(*i++);
		if ( rd.name.size() < str.size() ) continue;
		if ( tolower( rd.name.substr(0, str.size())) == p)
		{
			if (nNextNum <= nCount)	return rd.index;
			nCount++;
		}
	}
	
	// 없으면
	return -1;
}


///	\brief	mcd 처리용함수
///	\return	false	:	보통 false로 반환
///			true	:	반환 가능하나?
bool Mcd::proc()
{
	int key, bkey;
	bool bSearch = false;
	
	bExit = false;
	
    if (m_pOrder.size() == 0) {
        LOG("Directory Size : 0");
        return false;
    }
    
	if (m_pCur==m_pOrder.end()) 
        m_pCur = m_pOrder.begin();
	
	win = newwin(g_nLINES, g_nCOLS, 0, 0);

	int nSearchCnt = 0;
	
	do
	{
		if (draw() == false) return false;
		key = getch();

		nodelay(stdscr, TRUE);
		int nKey2 = getch();
		int nKey3 = getch();
		int nKey4 = getch();
		int nKey5 = getch();
		nodelay(stdscr, FALSE);

		LOG("MCD [%d][%d][%d][%d][%d]", key, nKey2, nKey3, nKey4, nKey5);
		
		// 리모트 접속 End, Home 키
		// 27, 79, 72 (linux) ::  27, 91, 72 (vt100)
		if (key == 27 && (nKey2 == 91 || nKey2 == 79))
		{
			if (nKey3 == 72)	key = KEY_HOME;
			if (nKey3 == 70)	key = KEY_END;
			// Konsole. End Home 키
			if (nKey3 == 49 && nKey4 == 126) key = KEY_HOME;
			if (nKey3 == 52 && nKey4 == 126) key = KEY_END;
		}
		if (key == 263) key = KEY_BS;

		if (nKey3 == 91 && nKey4 >= 'A' && nKey4 <= 'E')  // Konsole 에서 F1~F5 키 (konsole)
			key = KEY_F(nKey4-'A'+1);
		if (nKey3 == 49 && nKey4 >= 49 && nKey4 <= 52) // Konsole 에서 F1~F5 키 (xterm xfree 3.x)
			key = KEY_F(nKey4-49+1);
		if (nKey2 == 79 && nKey3 >= 80 && nKey3 <= 83) // Remote F1~F4
			key = KEY_F(nKey3-80+1);
		
		if (key == KEY_RESIZE) {
			g_nLINES = LINES;
			g_nCOLS = COLS;
			continue;
		}
		
		if (!bSearch && ( ('A' <= key && key <= 'z') || key == '.' ) ) bSearch = true;
		if (bSearch &&  ( (32<= key && key <=126) || key == KEY_BS || key == 9) ) // 9 -> TAB
		{
			int tmp;
			// search mode;
			// 뒷부분에 key를 넣고
			
			if (key == KEY_BS) 
			{
				m_sSearch.erase(m_sSearch.size()-1, 1);
				if (m_sSearch.empty()) {bSearch = false; continue;}
			}
			else if (key == 9) // 9 -> TAB
			{
				nSearchCnt++;
			}
			else
			{
				m_sSearch += (char) key;
			}
			
			// m_sSearch로 시작하는 문자를 찾는다.
			if ((tmp = Search(m_sSearch, nSearchCnt))!= -1)
				m_pCur = m_pOrder.begin() + tmp;
			else
				nSearchCnt = 0;
			continue;
		}

		nSearchCnt = 0;
		bSearch = false;
		m_sSearch.erase();
		
		switch(key)
		{
			case 13: 
			case 10: 
				return true;
			case KEY_UP: up(); break;
			case KEY_DOWN: down(); break;
			case KEY_LEFT: left(); break;
			case KEY_RIGHT: right(); break;
			case KEY_NPAGE:
				for (int t=0; t<g_nLINES-4; t++) down(); break;
			case KEY_PPAGE:
				for (int t=0; t<g_nLINES-4; t++) up(); break;
			case 27:
				nodelay(stdscr, TRUE);
				key = getch();
				nodelay(stdscr, FALSE);
			case 17: // CTRL + Q
				if (key == ERR || key=='x' || key == 'X' || key == 27 || key == 17)
				{
					if (config.GetBool("AskMcdExit") == true)
					{
						int nYN = YNBox("Do you really want to quit the mcd ?", 0);	
						if (nYN == YN_Y) return false;
						else continue;
					}
					else return false;
				}
				break;
			

			default: if(McdExecute(key) == ERROR) bExit = true; break;
		}
	}while(!bExit);
	
	clear();
	refresh();
	return true;
}

///	\brief	str이 가르키는 directory로 현재 위치를 이동시킨다.
///	\param	str		현재 directory로 위치시키고자하는 directory명
void 
Mcd::setCur(const string &str)
{
	//               01234567890123456789
	// m_pRoot->name = "/sdfsd/sdfsdsf/"
	//              "/sdfsd/sdfsdsf/p/3/"
	
	// str이 "" 일 경우 처음 위치로
	if (str.empty())
	{
		m_pCur = m_pOrder.begin();
		return;
	}
	
	if (   str[0] != '/'                // 절대경로가 아닐때
		|| str==m_pRoot->name				// 루트일때
		|| str.size() < m_pRoot->name.size()  // 루트사이즈보다 작을때
		|| str.substr(0, m_pRoot->name.size()) != m_pRoot->name)
	{
		
		m_pCur = m_pOrder.begin();
		return;
	}
	
	// /
	// 012345678901234
	// /home/ioklo/ppp
	StringTokenizer st(str.substr(m_pRoot->name.size()), "/");	
	
	pDirIterator i;	
	dir *node = m_pRoot;
	
	while (st.Next())
	{
		const string &t = st.Get();
		
		// 자식들 중에 있는거 찾아낸다.
		for (i = node->node.begin(); i!=node->node.end() ;i++)
			if ((*i)->name == t) break;		
		
		if (i == node->node.end()) {m_pCur = m_pOrder.begin(); return;}
		
		node = (*i);
	}
		
	m_pCur = m_pOrder.begin() + (*i)->index;
}

///	\brief	mcd상에서 위 directory로 이동한다.
void 
Mcd::up()
{
	pDirIterator i;
	
	if ((*m_pCur)->parent)
	{		
		if ((*m_pCur)->depth != (*(m_pCur-1))->depth )
		{
			pDirIterator t;
			for (t = m_pCur-1 ; t!=m_pOrder.begin()-1; t--)
				if ((*t)->depth == (*m_pCur)->depth) break;
				
			if (t != m_pOrder.begin()-1) m_pCur = t;
			else
				left();
		}
		else m_pCur--;
	}
	else
		left();
}

///	\brief	mcd상에서 아래 directory로 이동한다.
void 
Mcd::down()
{
	// 아래부분에 뭔가 있을 경우
	if ((*m_pCur)->parent)
	{
		if (m_pCur+1 == m_pOrder.end() || (*m_pCur)->depth != (*(m_pCur+1))->depth )
		{
			pDirIterator t;
			for (t= m_pCur+1 ; t!=m_pOrder.end(); t++)
				if ((*t)->depth == (*m_pCur)->depth) break;
				
			if (t != m_pOrder.end())
				m_pCur = t;
			else
				right();
		}
		else m_pCur++;
	}
}

///	\brief	mcd상에서 왼쪽(상위 directory)로 이동한다.
void
Mcd::left()
{
	if ((*m_pCur)->parent) m_pCur=m_pOrder.begin()+(*m_pCur)->parent->index;
}

///	\brief	mcd상에서 오른쪽(하위 directory)로 이동한다.
void
Mcd::right()
{
	if (!(*m_pCur)->node.empty()) m_pCur=m_pOrder.begin()+(*m_pCur)->node.front()->index;
	else 
	{
		string p = (*m_pCur)->path();
		Scan(*m_pCur, 1);
		setCur(p);
		if ((*m_pCur)->node.empty())
			if (m_pCur+1 != m_pOrder.end()) m_pCur++;
		else
			if (!(*m_pCur)->node.empty() && (*m_pCur)->depth - m_nSCol == 5)
					m_nSCol = m_nSCol + 1;
	
	}
}

///	\brief	mcd 정렬을 한다.
void 
Mcd::setOrder()
{
	vector<dir*> st;
	dir *node;
	int ind=0;
	int row=0, odepth=-1;
	
	m_pOrder.clear();
			
	st.push_back(m_pRoot);
	while(!st.empty())
	{
		node = st.back();
		st.pop_back();
		
		if (node->depth <= odepth) row++;
		odepth = node->depth;
		
		node->row  = row;
		node->index= ind;
		
		ind++;
		m_pOrder.push_back(node);				
		copy(node->node.rbegin(), node->node.rend(), back_inserter(st));
	}
	
	m_pCur = m_pOrder.begin();
}

