///	\file	Mcd_draw.cpp
///	\brief	Mcd_draw.cpp

#include "Mcd.h"
#include "colorset.h"

using namespace std;
using namespace MLS;

int col_location[13]={0, 4, 18, 32, 46, 60, 74, 88, 102, 116, 130, 144, 158 };	///< 화면에 그릴 tree 깊이(x위치)

///	\brief	mcd draw 함수
bool Mcd::draw()
{
	vector<chtype> line;
	dir *node;
    
    dir *pcur = *m_pCur;
    
	int row, col, odep=0;
	int nRowSize = 0;
	int i, j;
	
	// 가로 개수 정하기
	for (i = 0; i < 13; i++)
	{
		if (g_nCOLS - 25 < col_location[i])
		{
			nRowSize = i;
			break;
		}
		
		nRowSize = 12;
	}
	
	if (pcur->row - m_nSRow > g_nLINES - 5) m_nSRow = pcur->row - g_nLINES + 5;
	if (pcur->depth - m_nSCol > nRowSize) m_nSCol = pcur->depth - nRowSize;
	if (pcur->row - m_nSRow < 0) m_nSRow = pcur->row;
	if (pcur->depth - m_nSCol < 1)
	{
		 m_nSCol = pcur->depth-1;
		 if (m_nSCol == -1) m_nSCol=0;
	}
	
	// 화면 지우기	
	setcol(g_Color.MCD, win);
	for (int j=0;j<g_nLINES; j++)
	{
		wmove(win, j, 0);
		whline(win, ' ', g_nCOLS);
	}

	
	setcol(g_Color.MCDstat, win);
	wmove(win, 0, 0);
	whline(win, ' ', g_nCOLS);
	mvwprintw(win, 0, 0, "%s", m_sTitle);
	
	// 이외의 그릴 것을 나타낸다. (ZipMcd, DirMcd 따로)
	DrawEtc();
	
	// 밑 화면 그리기
	if (g_Color.Func.back >=8 ) attron(A_BLINK);
	attron(COLOR(COLOR_BLACK, g_Color.Func.back%8));
	for (i=1; i<8;i++)
		mvwaddch(win, g_nLINES-1, i*(g_nCOLS/8), VLINE);
	
		
	if (!m_sSearch.empty())
	{
		setcol(g_Color.MCD, win);
		mvwprintw(win, 1, 0, "Search : [%-10s]", m_sSearch.c_str());
		
	}
	
	for (pDirIterator i=m_pOrder.begin(); i!=m_pOrder.end(); i++)
	{
		node = *i;

		if (odep < node->depth)
			line.push_back(VLINE);
		else
			while(node->depth < odep)
			{
				odep--;
				line.pop_back();
			}
		
		odep = node->depth;
		col  = node->depth;
		row  = node->row;
				
		// 출력 다했으면 종료		
		if (node->depth != 0 && node->parent->node.back()==node)
			line[col-1] = ' ';
			
		if (row - m_nSRow > g_nLINES - 5) break;
		if (row - m_nSRow < 0) continue;
		
		setcol(g_Color.MCD, win);
		wprintw(win, "");
		
		
		if (node != m_pRoot && node->parent->node.front()!=node) 
		{
			for (int t = m_nSCol; t < col && t < m_nSCol+nRowSize; t++)
			{
				setcol(g_Color.MCDLine, win);
				mvwaddch(win, row-m_nSRow+2, col_location[t-m_nSCol+1], line[t]);
				
			}
		}		
		
		if (col - m_nSCol > nRowSize ) continue;
		if (m_nSCol != 0 && col - m_nSCol < 1 ) continue;
						
		if (node->depth==0)
		{// 루트라면
			wmove(win, row-m_nSRow+2, 2);
			
			if (node == pcur) 
				setrcol(g_Color.MCD,win);
			else 
				setcol(g_Color.MCD,win);
			
			waddch(win, '/');
			
			
			// 다음은 선택박스가 이상하게 보이는것을 방지
			setcol(g_Color.MCD, win);
			wprintw(win, "");
			
		}		
		else
		{// 아니라면
			if (node->parent->node.size() > 1)
			{	
				// 디렉토리가 하나가 아닐때 
				if (node->parent->node.front()==node)
				{	
					// 첫번째 노드 
					setcol(g_Color.MCDLine, win);
					wmove(win, row-m_nSRow+2, col_location[col-m_nSCol]);
					waddch(win, TTEE);
					
				}
				else
				{	
					// 그 이외의 디렉토리 
					wmove(win, row-m_nSRow+2, col_location[col-m_nSCol]);

					setcol(g_Color.MCDLine, win);
					if (node->parent->node.back()==node) 
						waddch(win, LLCORNER); 
					else 
						waddch(win, LTEE); 
					
				}	
			}
			else
			{
				wmove(win, row-m_nSRow+2, col_location[col-m_nSCol]);
				setcol(g_Color.MCDLine, win);
				waddch(win, HLINE); 
				
			}
			
			setcol(g_Color.MCDLine, win);
			if (node->bCheck == false)
				waddch(win, '+');
			else
				waddch(win, HLINE);
			
						
			// 선을 하나 더 긋고 이름 출력 
			if (node == pcur)
			{
				setrcol(g_Color.MCD, win);
				if (node->name.size() <= 12)
					wprintw(win, "%-12s", node->name.c_str());
				else
					wprintw(win, "%-11.11s~", node->name.c_str());
				
				
				// 다음은 선택박스가 이상하게 보이는것을 방지
				setcol(g_Color.MCD, win);
				wprintw(win, "");
				
			}
			else
			{
				if (node->name.size() <= 12)
				{
					if (node->linked) 
						setcol(11, g_Color.MCD.back, win);
					else 
						setcol(g_Color.MCD, win);
					
					wprintw(win, "%s ", node->name.c_str());
					
					
					if (!node->node.empty())
					{
						if (node->linked) 
							setcol(11, g_Color.MCDLine.back, win);
						else 
							setcol(g_Color.MCDLine, win);
						
						whline(win, HLINE, 12-node->name.size());
						
						
					}
				}
				else 
				{
					if (node->linked) 
						setcol(11, g_Color.MCD.back, win);
					else 
						setcol(g_Color.MCD, win);
					
					wprintw(win, "%-11.11s~", node->name.c_str());
					
				}
			}
		}
	}
	
	redrawwin(win); // Gnome 콘솔에서 깨지는 버그 수정
	wrefresh(win);
	return true;
}
