/* *************************************************************************
 *   Copyright (C) 2004 by Byoungyoung, La                                 *
 *   la9527@yahoo.co.kr                                                    *
 *                                                                         *
 ************************************************************************* */ 

///	\file	TargzUtil.h
///	\brief	TargzUtil.h
#ifndef TargzUtil_h_
#define TargzUtil_h_
 
#include "define.h"
#include "file.h"
#include "strutil.h"
#include "mlslocale.h"
#include "exception.h"
#include "progress.h"

namespace MLS
{
	///	\brief	압축 화일 확장자
	enum ZIPTYPE
	{
		TAR_GZ,			///< tar.gz
		TAR_BZ,			///< tar.bz
		TAR,			///< tar
		GZ,				///< gz
		BZ,				///< bz
		ZIP,			///< zip
		RPM,			///< rpm
		DEB,			///< deb
		ALZ				///< unalz
	};
	
	///	\brief	tar 옵션
	enum
	{
		TAR_APPEND,		///< tar append
		TAR_DELETE		///< tar delete
	};

	///	\brief	zip, tar.gz 파일 관리 class
	class TargzUtil:public Counter
	{
		private:
			map<string, int>	m_tReadCol;
			const string		m_TarCommand;
			string  		m_Filename;		///< zip filename
			string			m_Dir;			///< zip file path
			string			m_sCwd;			///< 현 작업 공간 directory
			
			string			m_GzipDir;		///< gzip 디렉토리 위치
			string			m_Bzip2Dir;		///< bzip2 디렉토리 위치
			string			m_TarDir;		///< tar 디렉토리 위치
			
			bool			m_isZip;		///< Zip 파일 여부
			vector<File*>	m_tFileList;	///< 압축 파일에 있는 filelist
			vector<string>	m_ErrorInfo;	///< error info
			ZIPTYPE			m_isFileInfo;	///< 압축 file 정보(tar.gz, tar...)
			string			DetectTarCommand() const;
			
		protected:
			string	GetTarFileName(void);
			bool	IsFileCreate(const string& sFilename = "");
			
			int		FileControl(const string& sFullName, int nAppendDel);
			int		Fullname_To_Filename(string* sFullFile, string* sFilename, bool* bDir);
			int		LineFormatRead(vector<string>&	vLineToken, File* pFileInfo, int nFormat);
			
			int		FileListCheck_DirInsert(void);
			
		public:
			TargzUtil(const string& sDir_Filename, bool isZip);
			TargzUtil(const string& sDir, const string& sFilename, bool isZip);
			~TargzUtil();
			
			///	\brief	파일 개수 반환 함수
			///	\return	파일 개수
			uint 	GetCount(void) 	{ 	return (uint)m_tFileList.size(); }
			
			ZIPTYPE 	GetZipType(void) { return m_isFileInfo; }
			
			///	\brief	Tar, gzip 등 디렉토리 위치 선정. 
			///	\param	GzipDir		gzip 디렉토리 위치
			///	\param	Bzip2Dir	bzip 디렉토리 위치
			///	\param	TarDir		tar  디렉토리 위치
			void	SetTarDir(string& GzipDir, string& Bzip2Dir, string& TarDir) 
			{
				m_GzipDir 	= GzipDir; m_Bzip2Dir	= Bzip2Dir;	m_TarDir 	= TarDir; 
			}

			void	SetWorkDir(const string& dir) { m_sCwd = dir; }
			
			string	GetZipFilePath(void) { return m_Dir; }
			
			int		GetFileInfo(void);
			int		FileExtCheck(const char* sExt);
			int		CommandExecute(const string& sCommand);
			
			int		GetDir_Files(string& s_Dir, vector<MLS::File*>* pRe_Dir);
			int		GetDir_AllFiles(string& s_Dir, vector<MLS::File*>* pRe_Dir);
			int		GetAll_Files(vector<MLS::File*>* rRe_File);
	
			uint	GetAllDataSize(void);
			
			int		Compress(vector<MLS::File*>& t_FileList, int nAppendDel = TAR_APPEND);
			int		Compress(vector<string>& t_FileList, int nAppendDel = TAR_APPEND);
			int		Compress(MLS::File* pFile, int nAppendDel = TAR_APPEND);
			int		Compress(const string& s_Dir = ".");
			
			int		Uncompress(vector<MLS::File*>& t_FileList, const string& sTargetDir = ".");
			int		Uncompress(vector<string>& t_FileList, const string& sTargetDir = ".");
			int		Uncompress(const string& s_Dir = ".");

			int		FileListRead(void);
			
            ///	\brief	에러 리스트가 있으면 돌려주기 위한 함수
            vector<string>		GetErrorList(void)	{ return m_ErrorInfo; }
            int 	GetErrorList(vector<string>& tErrorList) { tErrorList = m_ErrorInfo; }
	};
	
};

#endif
