///	\file	ZipMcd.h
///	\brief	ZipMcd.h

#include "ZipMcd.h"
#include "colorset.h"

using namespace std;
using namespace MLS;

///	\brief	ZipMcd 생성자 함수
///	\param	vZipVector	File 리스트
///	\param	sDir		디렉토리
///	\param	_title		mcd 제목
///	\param	sZipFile	Zip 파일명
ZipMcd::ZipMcd(vector<MLS::File*> vZipVector, string sDir, const char* _title, string sZipFile):Mcd(sDir, _title)
{
	m_vZipVector = vZipVector;
	m_sZipFile = sZipFile;
	Rescan();

	UpdateConfig();
}

/// @brief 컨피그에서 데이터를 읽어온다.
void ZipMcd::UpdateConfig()
{
	m_McdZipFunc[0].addEntry(config.GetValue("McdZipFuncF1"));
	m_McdZipFunc[1].addEntry(config.GetValue("McdZipFuncF2"));
	m_McdZipFunc[2].addEntry(config.GetValue("McdZipFuncF3"));
	m_McdZipFunc[3].addEntry(config.GetValue("McdZipFuncF4"));
	m_McdZipFunc[4].addEntry(config.GetValue("McdZipFuncF5"));
	m_McdZipFunc[5].addEntry(config.GetValue("McdZipFuncF6"));
	m_McdZipFunc[6].addEntry(config.GetValue("McdZipFuncF7"));
	m_McdZipFunc[7].addEntry(config.GetValue("McdZipFuncF8"));
	m_McdZipFunc[8].addEntry(config.GetValue("McdZipFuncF9"));
	m_McdZipFunc[9].addEntry(config.GetValue("McdZipFuncF10"));
	m_McdZipFunc[10].addEntry(config.GetValue("McdZipFuncF11"));
	m_McdZipFunc[11].addEntry(config.GetValue("McdZipFuncF12"));
}

// @brief 컨피그 파일에서 데이터를 나눠준다
void ZipMcd::SaveConfig()
{
	// 저장할 것이 없음

}

///	\brief	재검색 전체검색과 같다.
///	\param	vZipVector	File 리스트
///	\param	sDir		디렉토리
///	\param	_title		mcd 제목
///	\param	sZipFile	Zip 파일명
///	\return	SUCCESS, ERROR
int
ZipMcd::
Rescan(int nDepth)
{
	if (m_pRoot)
	{
		for (pDirIterator p = m_pOrder.begin(); p!=m_pOrder.end(); ++p)
			delete *p;
	}

	m_pRoot = new dir("/", NULL, false,  false, true);
	return Scan(m_pRoot, nDepth); // 루트를 중심으로 다시 스캔
}

///	\brief	현재디렉토리 검색 여기선 전체검색과 같다.
///	\param	sDir	File 리스트
///	\return	SUCCESS, ERROR
int
ZipMcd::
AddDirectory(const std::string &sDir)
{
	if (m_pRoot == NULL)
	{
		LOG("Root Invalid");
		return ERROR;
	}

	if (sDir == "") return ERROR;

	File	tFile;
	Mcd::dir *p = m_pRoot;

	tFile.FullName = sDir.c_str();

	AddDir(m_pRoot, &tFile, 0);
	setOrder();
	return SUCCESS;
}

///	\brief	현재디렉토리 검색 여기선 전체검색과 같다.
///	\param	pRootTree	루트 dir 포인터
///	\param	pFile		현재 파일
///	\param	nDepth		검색할 디렉토리 깊이 여기선 사용하지 않는다.
///	\return	SUCCESS, ERROR
int
ZipMcd::
AddDir(dir* pRootTree, File* pFile, int nDepth)
{
	StringTokenizer		tDirSt(pFile->FullName, "/");

	string			sTmpDir;
	dir*			pTree = m_pRoot;
	dir*			pSubTree;
	dir*			pReTree;

	pDirContainer	vDir;
	pDirIterator	piCount;

	bool	bFind = false;
	int			nStrDepth = 0;

	if (pRootTree == NULL) return ERROR;
	if (pFile == NULL) return ERROR;

	while(tDirSt.Next())
	{
		bFind = false;
		sTmpDir = tDirSt.Get();

		//LOG(": [%s] [%d] [%d]", pTree->name.c_str(), pTree->node.size(), nStrDepth);

		// 디렉토리 찾고 같으면 ppTree 리턴
		for (piCount = pTree->node.begin(); piCount!= pTree->node.end() ;piCount++)
		{
			if ((*piCount)->name == sTmpDir)
			{
				pTree = *piCount;
				//LOG("DIR == [%s] [%s]", sTmpDir.c_str(), pTree->name.c_str(), pTree->node.size());
				bFind = true;
				break;
			}
		}

		if (bFind == false)
		{
			pTree->node.push_back(new dir(sTmpDir, pTree, false, false, true));
			LOG("Push :: [%s] [%d] [%s]", pTree->name.c_str(), pTree->node.size(), sTmpDir.c_str());

			if (bMcdSort)
				sort(pTree->node.begin(), pTree->node.end(), mcdsort());

			pTree = pTree->node.back();
			//LOG("View :: [%s] [%d]", pTree->name.c_str(), pTree->node.size());
		}

		nStrDepth++;
		//if (nStrDepth == nDepth) break;
	}

	return SUCCESS;
}

///	\brief	현재디렉토리 검색 여기선 전체검색과 같다.
///	\param	pTree	루트 dir 포인터
///	\param	nDepth	검색 깊이. 사용하지 않는다.
///	\return	SUCCESS, ERROR
int
ZipMcd::
Scan(dir *pTree, int nDepth)
{
	File*	pFile = NULL;

	dir*			pTmpTree_1;
	dir*			pTmpTree_2;

	int			nCount = 0;

	vector<File*>	vZipDirTemp;

	if (pTree == NULL) return ERROR;

	LOG("ALL Size [%d]", m_vZipVector.size());

	for (nCount = 0; nCount < m_vZipVector.size(); nCount++)
	{
		pFile = m_vZipVector[nCount];

		// 디렉토리만 넣는다.
		if (pFile->bDir)
		{
			vZipDirTemp.push_back(pFile);
		}
	}

	LOG("Dir Size [%d]", m_vZipVector.size());

	string	sTmpDir;

	destroy(pTree, false);	// 구성요소들을 destroy.. 시킨다.
	nodelay(stdscr, TRUE);


	for (nCount = 0; nCount < vZipDirTemp.size(); nCount++)
	{
		pFile = vZipDirTemp[nCount];

		LOG("%s [%d]" , pFile->FullName.c_str(), vZipDirTemp.size());
		AddDir(pTree, pFile, nDepth);
	}

	nodelay(stdscr, FALSE);
	setOrder();
	LOG("SCAN OK");
	return SUCCESS;
}

///	\brief	ZipMcd 에 필요한 내용을 그린다.
///	\return	SUCCESS, ERROR
int ZipMcd::DrawEtc(void)
{
	int i;

	// Function 그리기
	setcol(g_Color.Func, win);
	wmove(win, g_nLINES-1,0);
	whline(win, ' ', g_nCOLS);
	for (i=0; i<8; i++)
		mvwprintw(win, g_nLINES-1, 2+i*(g_nCOLS/8),"%s", m_McdZipFunc[i+1].getName());

	// F 그리기
	setcol(g_Color.FuncA, win);
	mvwprintw (win, g_nLINES-1, 0, "F");
	for (i=0; i<8; i++)
		mvwprintw(win, g_nLINES-1, 1+i*(g_nCOLS/8), "%d", i+2);

	setcol(g_Color.MCD, win);
	mvwprintw(win, g_nLINES-2, 0, " Path [ %s::%s ]", m_sZipFile.c_str(), (*m_pCur)->path().c_str());

	return SUCCESS;
}

///	\brief	도움말을 보여준다.
void
ZipMcd::Help()
{
	int width = 70;
	int height = 17;

	width +=4;

	WINDOW *win = newwin(height, width, (g_nLINES-height)/2, (g_nCOLS-width)/2);
	//	wclear(win);
	wbkgd(win, COLOR(COLOR_WHITE, 3));

	wattron(win ,A_BOLD);
	wborder(win, VLINE, VLINE, HLINE, HLINE, ULCORNER, URCORNER, LLCORNER, LRCORNER);

	wattroff(win, A_BOLD);

	// title 출력
	wattron(win, COLOR(COLOR_BLACK, COLOR_WHITE));
	wmove(win, 1, 1);
	whline(win, ' ', width-2);
	mvwprintw(win, 1, 30, "ZipMcd Help");
	wattroff(win, A_BOLD);

	// msg
	wattron (win, COLOR(COLOR_WHITE, 3));
	wattron (win, A_BOLD);

	mvwprintw(win, 3, 2,  "/ , \\  : Shell");
	mvwprintw(win, 4, 2,  "+      : Current directory OneSearch");
	mvwprintw(win, 5, 2,  "-      : Current directory Delete");
	mvwprintw(win, 6, 2,  "=      : Current directory AllSearch");
	mvwprintw(win, 13, 2, "Alt+X  : Exit");

	mvwprintw(win, 3,  40, "F1    : Help");
	mvwprintw(win, 4,  40, "F2    : Rescan");
	mvwprintw(win, 5,  40, "F3    : (NULL)");
	mvwprintw(win, 6,  40, "F4    : (NULL)");
	mvwprintw(win, 7,  40, "F5    : Reflesh");
	mvwprintw(win, 8,  40, "F6    : (NULL)");
	mvwprintw(win, 9,  40, "F7    : (NULL)");
	mvwprintw(win, 10, 40, "F8    : (NULL)");
	mvwprintw(win, 11, 40, "F9    : (NULL)");
	mvwprintw(win, 12, 40, "F10   : (NULL)");
	mvwprintw(win, 13, 40, "F11   : (NULL)");
	mvwprintw(win, 14, 40, "F12   : (NULL)");
	wattroff(win, A_BOLD);

	wrefresh(win);

	getch();
	delwin(win);
}

///	\brief	키 실행
///	\param	nKey	키번호
///	\return	SUCCESS, ERROR
int
ZipMcd::
McdExecute(int nKey)
{
	// 나중엔 key matching 형태로 수정해야 한다.
	switch(nKey)
	{
		// 자신의 디렉토리의 깊이 하나만 찾아준다.
		case '+':
		{
			WINDOW*	pWin = MsgWaitBox("Wait", "Please wait !!! - Cancel Key [ESC]");

			string p = (*m_pCur)->path();
			Scan(*m_pCur, 1);
			setCur(p);
			if (pWin) MsgWaitEnd(pWin);
			break;
		}

		// 자신의 디렉토리에서 밑의 전체를 찾아준다.
		case '=':
		{
			WINDOW*	pWin = MsgWaitBox("Wait", "Please wait !!! - Cancel Key [ESC]");

			string p = (*m_pCur)->path();
			Scan(*m_pCur, 0);
			setCur(p);
			if (pWin) MsgWaitEnd(pWin);
			break;
		}

		case '-':
		{
			string p = (*m_pCur)->path();
			destroy(*m_pCur);
			setCur(p);
			break;
		}

		case KEY_F(1):
		{
			Help();
			break;
		}

		case KEY_F(2):
		{
			int p= YNBox("Rescan directory now?", YN_Y, COLOR_MAGENTA);
			if (p==YN_N || p==-1) break;

			WINDOW*	pWin = MsgWaitBox("Wait", "Please wait !!! - Cancel Key [ESC]");
			string pa = (*m_pCur)->path();
			Rescan();
			if (pWin) MsgWaitEnd(pWin);

			setCur(pa);
			break;
		}

		case KEY_F(5):
		{
			g_nLINES = LINES;
			g_nCOLS = COLS;
			draw();
			break;
		}

	}
	return SUCCESS;
}
