///	\file	action.cpp
///	\brief	action.cpp
#include <string>
#include "action.h"
#include "strutil.h"

using namespace std;
using namespace strutil;
using namespace MLS;

///	\brief	Funtion Entry를 추가한다.
///	\param	p		추가할 Entry
void Action::addEntry(const string &p)
{
	//	line 안에서 cmd랑 name을 분리한다..
	//  초반의 [] 는 name
	
	// [name] prog1; prog2; prog3; ...;;
	
	if (p.empty()) return;
	
	// . 화면에 출력할 값을 찾는다.
	if (p[0] == '[')
		name = getbetween (p, '[', ']');
		
	// . 추가할 명령어를 찾아 낸다. ===
	string::size_type os = p.find_first_of(']', p.find_first_of('[') );
	string::size_type s  = p.find_first_of(';');
	
	// . 한 펑션 키에 여러게의 명령이 있다면 하나씩 명령어 추가
	while (s!=string::npos)
	{	
		string t = chop(p.substr(os+1, s-os-1));
		if (t!="") addCommand(t);
		
		os=s;
		s=p.find_first_of(';', s);
	}
	string t=chop(p.substr(os+1));
	if (t!="") addCommand(t);
	// ================================
} 
