#ifndef __KEYBIND_H__
#define __KEYBIND_H__

#include <string>
#include <map>

namespace MLS 
{
	class KeyBind
	{
		std::map<std::string, int> _definitions;
		std::map<int, std::string> _bindings;
		std::map<int, std::string> _meta_bindings;
		std::map<int, std::string> _func_bindings;
		std::map<std::string, std::string> _help_bindings;
			
	public:
		KeyBind();
		~KeyBind();

		std::string _sVersion;

		static      KeyBind &GetInstance();
				
		bool        Load(const std::string &);
		
		int         GetDefinition(const std::string &);		
		std::string GetCommand(int key);
		std::string GetMetaCommand(int key);
		std::string GetKeyStr(std::string sCommand);
		std::string GetHelpCmd(std::string sCommand);
		std::string GetHelpMetaKey(int Key);
		std::string GetHelpKey(int Key);
		
		std::string GetFuncKey(int Key);
		void 		SetFuncKey(int Key, std::string& sCmd);
		void 		SetFuncKey(std::map<int, std::string>& mapFunc);
	};
	
//#define g_Keybind KeyBind::GetInstance()

}; // namespace 


#endif
