#ifndef __COMMAND_H__
#define __COMMAND_H__

#include <map>
#include <string>

namespace MLS 
{
	class Panel;
	class CommandImp;

	class Command
	{
		private:
			CommandImp* _imp;					
			
			typedef void (CommandImp::* CmdFun)();
			typedef std::map<std::string, CmdFun>	FuncMap;

			FuncMap _func;

		public:
			Command();
			~Command();
			
			void Init();
			void SetPanel(Panel *);
			
			int  Execute(const std::string &str);			///< 커맨드 메시지와 실행명령을 처리한다.
			int  ParseAndRun(const std::string &str);		///< str을 파싱한 다음 Run으로 실행한다
			
			int  Run(const std::string &str, bool = false); ///< 쉘에 의해서 실행 되는 커맨드
	};

	extern Command g_Command;

}; // namespace



#endif
