///	\file	dirreader.h
///	\brief	dirreader.h
#ifndef dirreader_h_
#define dirreader_h_

#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>

#include <string>

#include "file.h"
#include "reader.h"
#include "configure.h"

#include "errno.h"
#include "dialog.h"

namespace MLS {

///	\brief	directory 읽기 class
class DirReader : public Reader, public IConfigurable
{
protected:
	DIR         *m_handle;		///< DIR Handle
	dirent      *m_pEntry;		///< dirent struct
	struct stat  m_statbuf;		///< file 정보
	
	std::string  m_path;		///< Directory path
	char *m_lpath;				///< directory long path

	std::string  date_type;
	
public:
	DirReader();
	
	virtual bool Init(const std::string &path);
	virtual bool Next();
	virtual bool GetInfo(File &);
	virtual void Destroy();
	virtual bool isRoot();
	
	// IConfigurable Interface
	void UpdateConfig();
	void SaveConfig();

	///	\brief	Zip 파일을 보기 위한 함수
	///
	///	Sync를 위한 세팅
	///	\param	tFile	압축 풀 파일(/tmp)
	///	\return	무조건 ERROR 반환
	virtual	int  View(File& tFile, const string& sTmpDir) { return ERROR; }
	
	///	\brief	복사함수
	///
	///	Sync를 위한 세팅
	///	\param	tCpyData	반환 값
	///	\param	sTarget		복사 대상 값
	///	\return	무조건 ERROR 반환
	virtual int  Copy(vector<string>& tCpyData, string& sTarget) { return ERROR; }

	///	\brief	제거 함수
	///
	///	Sync를 위한 세팅
	///	\param	tRemoveData		제거 대상
	///	\return	무조건 ERROR 반환
	virtual int  Remove(vector<string>& tRemoveData) { return ERROR; }
	
	vector<MLS::File*> GetZipFiles() { vector<File*>	vFiles; return vFiles; }
};

};

#endif
