///	\file	history.cpp
///	\brief	명령어 history 정보 소스
#include "history.h"

using namespace MLS;
using namespace std;

static string null;		///<	history 파일안에서만 존재하는 null변수

///	\brief	생성자
History::History()
{
	m_cur = -1;
	bAdd  = true;
}
//             c   
// 0 1 2 3 4 5 6 7 8 
// a b c d e f g h

///	\brief	명령어 history를 추가한다.
///	\param	path	??
void History::AddEntry(const string &path)
{
	if (!bAdd)
	{
		bAdd = true;
		return;
	}
	m_cur++;
	
	// . history용량이 다 찾으면 하나 제거
	if (m_paths.size() > m_cur)
		m_paths.erase(m_paths.begin()+m_cur, m_paths.end());
	
	// . history에 추가
	m_paths.push_back(path);	
}

///	\brief	바로 하나전 history를 알아낸다.
///	\return	바로 하나전 history
const string &History::GetPrev()
{
	if (m_cur == -1) return null;
	if (!isFront()) m_cur--;	
	
	bAdd = false;
	
	return m_paths[m_cur];
}

///	\brief	다음 명령 history로 간다.
///	\return	다음 명령 history
const string &History::GetNext()
{
	if (m_cur==-1) return null;
	if (!isBack()) m_cur++;
	
	bAdd = false;
	
	return m_paths[m_cur];
}

///	\brief	현재 history위치가 가장 처음인지 알아내는 함수
///	\return	true	:	현재 위치가 가장 처음임.\n
///			false	:	현재 위치가 처음이 아님.
bool History::isFront()
{
	return (m_cur == 0);
}

///	\brief	현재 history위치가 가장 마지막인지 알아내는 함수
///	\return	true	:	현재 위치가 가장 마지막임.\n
///			false	:	현재 위치가 마지막이 아님.
bool History::isBack()
{
	return (m_cur == m_paths.size()-1);
}
