/**
 * @file	mainframe.h
 * @brief	mainframe header file
 * @author	la9527
 * @date	2004-08-22
 */
#ifndef MLSMAINFRAME_H
#define MLSMAINFRAME_H

#include "define.h"
#include "panel.h"
#include "DirMcd.h"
#include "command.h"
#include "clipboard.h"
#include "colorset.h"
#include "configure.h"

namespace MLS {
/**
	@brief	MainFrame 클래스

	Panel들을 관리한다.
*/
					
class MainFrame : public IConfigurable
{
private:
	Panel   	_tPanel[2];
	
	ClipBoard   _tClipboard;
	
	bool        _bExit;
	bool		_bShell;
	bool		_bHints;   ///< hint 를 보여줄것인가?
	bool		_bSplit;   ///< 창나누기인가 아닌가.
	int			_nActive;  ///< Active한 창을 가리킨다 0, 1
	string		_sLastPath;   ///< 마지막 Path를 저장한다.
	MEVENT 		_beforeEvent; ///< 더블클릭 대체 방법으로 쓰임
	
//	WINDOW *	_win0;     ///< 전체 윈도우
	WINDOW *	_win1;
	WINDOW *	_win2;
	
	//  configuration
	Action      _Func[12];

	void		MouseProc();
	int			XPositionToFunctionkey(const int xPosition);
	int			XPositionToFilePanel(const int x);
	void		SetXYLocalToPanel(int & x, int & y, const int panelindex);

public:
	MlsMenu    	_tMenu;
	KeyBind		_tKeyBind;

	MainFrame();
	~MainFrame();
	
	bool    Init();
	void    Destroy();
	
	void 	Do(bool bMcd = false);
	void    Draw();
	void	HintDraw();
	void	SetSplitWindow();
	void    Exit() { _bExit = true; }
	void	ShellExe(bool Shell) { _bShell = Shell; }
    void	NextWindow();
	void	Refresh();
	void    RefreshPanel(bool bReload = false);
	void	ReloadMenu() { _tMenu.Create();	}
	
	void	SwitchSplit();
	bool	IsSplit()	{ return _bSplit; }

	void    UpdateConfig();
	void    SaveConfig();

	friend class CommandImp;
	friend class Panel;
};

extern MainFrame *g_MainFrame;
};

#endif
