/// @file	panel.h
///	@brief	panel	headerfile
#ifndef __MLS_PANEL_H__
#define __MLS_PANEL_H__

#include <list>
#include <vector>
#include <string>
#include "define.h"

#include "file.h"
#include "drawutil.h"
#include "strutil.h"
#include "mlslocale.h"
#include "keydef.h"
#include "dialog.h"

#include "DirMcd.h"
#include "TargzUtil.h"

#include "mpool.h"
#include "reader.h"
#include "history.h"
#include "mlsmenu.h"
#include "keybind.h"
#include "colorset.h"
#include "selection.h"
#include "progress.h"
#include "configure.h"

#include "dirreader.h"
#include "ZipReader.h"

typedef unsigned int uint;		///< unsigned int 재정의

namespace MLS {
	
enum SortMethod
{
	SORT_NONE, 
	SORT_NAME,
	SORT_EXT,
	SORT_SIZE,
	SORT_TIME, 
	SORT_COLOR		
};

///	@brief	Panel class
class Panel : public IConfigurable
{
// Draw Section ( 플랫폼에 따라 어떻게 바뀔지 모르겠음 ) 
protected:
	WINDOW *_win;					///< 출력할 윈도우
	int		_cols;
	int		_lines;
	
// 일반 처리
protected:	
	typedef vector<File *>::iterator pFileIterator;///< vector<File *>
														/// 재정의	
	MemoryPool<File> _pool;			///< pool
	vector<File *> _file_list;      ///< 지금 리스트에 나타낼 파일들.,
	
	History        _tHistory;		///< history
    SortMethod     _eSortMethod;
		
	string			_path;		    ///< path
	string			_strSearch;		///< 찾고 있는 파일 문자
	
	uint _sel_size;					///< 선택한 파일들 크기
	uint _sel_num;					///< 선택된 파일들의 개수
			
	uint _cur,						///< 커서 위치(file index값)
		 _page;						///< page	
	int  _ncol,						///< ncol
		 _nrow,						///< 파일정보를 출력할 줄 개수
		 _npage;					///< 페이지 개수

	uint _ndir,						///< 디렉토리 개수
		 _nfile,					///< 파일 개수
		 _dir_size;					///< 현재 디렉토리 안의 파일크기 들의 합
	
	bool _bExit;					///< 프로그램을 끝내는 여부
	bool _bRoot;					///< 루트 디렉토리 인지 여부
	bool _bSearch;					///< 찾기모드인지 여부

	// Configuration
	bool _bShowHidden;
	bool _bDirSort;
	bool _bFixedRow;
	int  _column;
	int  _sort;
	
	// Zip파일을 위한
	int		_nZip;					///< nZip (zipfile : 1)
	string	_zipPath;				///< zipPath (view를 위한 path)
	string	_zipFullPath;			///< zipFullPath (view를 위한 fullpath)
	string	_sZipFile;				///< sZipFile (zip filename)
	string	_sZipFilePath;			///< sZipFilePtah (zip filepath)
	string	_sTmpPath;				///< TmpPath

	DirReader _Dir_Reader;			///< Dir_Reader
	ZipReader _Zip_Reader;			///< Zip_Reader
	
	Reader *_tReader;				///< tReader

	/// @brief		파일위치 설정.
	void Panel::SetCur(const int cur)
	{
		_cur = cur;
		_page = _cur / (_ncol * _nrow);
	}
	
public:
	Panel();
	~Panel();	
	void proc();
	
	// Windows
	void SetWindow(WINDOW *win, int w, int h);
	
	// commands	
	void	Refresh(bool bReload = false);

	int cmd_copy();
	int cmd_move();
	int cmd_remove();	
	
	int cmd_zip_copy(void);
	int cmd_zip_remove(void);
		
	// read	
	bool Read(const string &);
	
	void         Init();
	void         Sort();
	void         SetSortMethod(SortMethod sm) { _eSortMethod = sm; }
	Reader		*GetReader(const string &path);	
	ColorEntry  *GetColor(File &ext);
	
	string		ViewCurrentPath(void);
	string		GetRealPath(const string &);
	string		GetCurrentPath(void);
	File		GetCurrentFile(void);
	
	// 압축파일 관련 메소드.. 인터페이스에 통합시켜야 함..	
	void		SetZipCurrentPath(string sCurPath);
	void		SetPathView(string sCurPath);
	string		GetZipCurrentPath(void);
	string		GetPathView(void);
	vector<MLS::File*> GetZipFiles();
	bool        isZip();
	void		FileCompress(int nType);
	void	    Key_ZipInstall();
	
	// 그리기 메소드 
	void Draw(bool bDrawCursor = false);
	
	void DrawMode1(int, bool);
	void DrawMode2(int, bool);
	void DrawMode3(int, bool);
	void DrawMode4(int, bool);
	
	void DrawStatus();
	
	// select
	void Select(File &);
	void Deselect(File &);	
	Selection GetSelection();
	void      ToggleSelect();
	
	// search
	int  Search(const string &, int start = 0); 
	bool SearchProcess(int);  
	
	// 방향키 설정
	void	Key_Enter(bool bExe = false);
	void	Key_Left();
	void	Key_Right();
	void	Key_Up();
	void	Key_Down();
	void	Key_PageUp();
	void	Key_PageDown();
	void	Key_Home();
	void	Key_End();

	// 마우스 이벤트
	void MouseProc(const MEVENT& event);
	
	// IConfiguable
	void    UpdateConfig();
	void    SaveConfig();
	
	// 친구 설정.. 곧 절교할 예정	
	friend class CommandImp;
};

inline void Panel::SetZipCurrentPath(string sCurPath)
{ 
	if (sCurPath.substr(0, 1) == "/")
		_zipFullPath = sCurPath;
	else
		_zipFullPath = "/" + sCurPath;
}

inline void Panel::SetPathView(string sCurPath)
{ 
	if (sCurPath.substr(0, 1) == "/")
		_zipPath = _sZipFile + " :: " + sCurPath; 
	else
		_zipPath = _sZipFile + " :: /" + sCurPath; 
}
	
inline string Panel::GetZipCurrentPath(void)
{
	LOG("GetZipCurrentPath [%s] --------", _zipFullPath.c_str());
	return _zipFullPath;
}
	
inline string Panel::GetPathView(void)
{
	if (isZip() == true)
		return _zipPath;
	else
		return _path;
}
	
inline vector<MLS::File*> Panel::GetZipFiles()
{ 
	vector<File*>	vFiles;
		
	if (isZip() == true)
		vFiles = _tReader->GetFiles();
	return vFiles;
}

inline bool Panel::isZip()
{
	if (_nZip != 0) 
		return true;
	else
		return false;
}

} // namespace 

#endif
