///	\file	panel_copy.cpp
///	\brief	panel_copy.cpp
#include <string>
#include <iostream>
#include <sys/stat.h>
#include <errno.h>


#include "define.h"
#include "panel.h"
#include "DirMcd.h"
#include "dialog.h"
#include "strutil.h"

using namespace std;
using namespace strutil;

using namespace MLS;

// tar.gz 파일 압축 풀고 파일 복사.
int Panel::cmd_zip_copy(void)
{
	DirMcd mcd("", gettext(	"Select the directory where you want to copy these files"));
	mcd.AddDirectory(_path);
	mcd.setCur(_path);
	int nRt = 0;

	do
	{
		if (mcd.proc())
		{
			if ((nRt = access(mcd.getCur().c_str(), R_OK | W_OK)) == -1)
				MsgBox(	gettext("Error"), strerror(errno));
		}
		else
			return -1;
	}
	while(nRt == -1);
	
	string msg = gettext("To ") + mcd.getCur();
	
	StatBox s(gettext("Copy"), msg.c_str());
	s.setUL(gettext("Calculating file sizes..."));
	s.show();
	
	Selection sel = GetSelection();
	
	vector<string> unzip_files=sel.GetData();
	
	string sTarget_path = mcd.getCur();
	LOG("MCD PATH :: %s", sTarget_path.c_str());

	if (_tReader->Copy(unzip_files, sTarget_path) == ERROR)
	{
		return ERROR;
	}
	return SUCCESS;
}

int Copy(Selection &files, string target_path)
{
	/*DirMcd mcd("", "Select the directory where you want to copy these files");
	
	mcd.AddDirectory(_path);
	mcd.setCur(_path);
	
	if (!mcd.proc()) return -1;*/
	
	StatBox s(	gettext("Copy"), (gettext("To ") + target_path).c_str());
	
	s.setUL(gettext("Calculating file sizes..."));
	s.show();
	
	files.ExpandDir();	
	uint size = files.GetSize();
	
	string sizes = toregular(size), rest_size;	
	
	struct stat src_stat, tar_stat, dir_stat;
	
	FILE *fp, *out;	 // 원본, 타겟
    //	ostringstream count;
	char count[1024];	
	char *buf = new char[65536]; 	
	uint last_size, p=1, p_size=0, c_size;	
	int key;		
	
	// /home/ioklo/ 에서 복사 시작  /p/로..
	// /home/ioklo/mls/p.dir   ==> /p/mls/p.dir
	
	// /home/ioklo/ 현재 디렉토리 source_path
	// /p/          타겟 디렉토리 target_path
	// mls/         복사시점 디렉토리 cur_path
	// p.dir        파일 이름  cur_name
	// /p/mls/      타겟 복사시점디렉토리..  tcur_path = target_path + cur_path
	
	// mls/p.dir    = cur_path + cur_name
	// /p/mls/p.dir = tcur_path + cur_name
			
	string source_name;
	string target_name;
	
	string cur_path = files.GetBaseDir();	
	string tcur_path = target_path;
	
	bool bOverwriteAll = false, bSkipAll = false;
	bool bsDir=true;
	
	// 파일 복사
	for (int t=0; t<files.Size(); t++)
	{
		const string &cur_name = files[t];		
		LOG("%s", cur_name.c_str());
		
		// 파일 이름이 없을경우 continue	
		if (cur_name.empty()) continue;	
		
		// 파일 리스트가 디렉토리 라면
		if (cur_name[cur_name.size()-1]=='/') 
		{
			// 타겟 디렉토리가 있는지 검사한다..
			bsDir = true;	
			
			// /p/mls/
			cur_path = files.GetBaseDir() + cur_name;
			tcur_path = target_path + cur_name;		
			
			if (stat(tcur_path.c_str(), &dir_stat) != -1)
			{
				// 이미 디렉토리가 있다면
				if (YNBox(
					gettext("Directory exists, continue?"), 
					YN_N) == YN_N) break;
				continue;
			} 
			else if (mkdir(tcur_path.c_str(), 0755)==-1) // 디렉토리를 만든다.
			{// 실패하면..				
				MsgBox(
					gettext("Error"), 
					gettext("Directory Making error"));
				break;
			}
			continue;
		}
		// 이번 디렉토리가 실패이면.. 다음 디렉토리때까지  복사하지 않는다.
		if (!bsDir) continue;
		
		// 소스 이름과 타겟 이름 정하기	
		source_name =  cur_path + cur_name;
		target_name = tcur_path + cur_name;
					
		if (stat(source_name.c_str(), &src_stat)==-1)
		{
			// 소스가 없다니.. 참
			MsgBox(	COLOR_RED, 	
				gettext("Error"), 
				gettext("Source is not found : %s"), 
				source_name.c_str());
			break;
		}
		
		mode_t permission = src_stat.st_mode;
		
		//count.str("");
		//count << '<' << p << '/' << files.size() << '>';

		sprintf(count ,"<%ld/%ld>", p, files.Size());
		
		s.setUL(cur_name.c_str());
		
		//s.setBL(count.str().c_str());		
		s.setBL(count);
		s.setBR(sizes.c_str());	
		s.show();	
		
		if (stat(target_name.c_str(), &tar_stat)!=-1)
		{
			if (bSkipAll) continue;
			else if (bOverwriteAll == false)
			{// 파일이 있을 경우..
askagain:
				vector<string> q;			
					q.push_back(gettext("Overwrite"));
					q.push_back(gettext("Skip"));
					q.push_back(gettext("Rename"));
					q.push_back(gettext("Overwrite All"));
					q.push_back(gettext("Skip All"));
					q.push_back(gettext("Cancel"));

				int 	nSelect = 0;

				if (g_nCOLS > 100) // 화면이 넓져서 COLS 가 100 이하면 LIST 박스로 보이게 한다.
				{
					nSelect = SelectBox((gettext("File exists : ") + cur_name).c_str(), q, 0, COLOR_YELLOW);
				}
				else
				{
					ListBox tListBox(gettext("File exists : "), 0, COLOR_YELLOW);
					tListBox.SetItem(q);
					nSelect = tListBox.Do();
				}
				s.redraw();
				
				switch(nSelect)
				{
					case 0:	// overwrite
						break;
					
					case 1: // skip
						p_size += src_stat.st_size;
						p++;
						continue;
						
					case 2: // rename 
					{
						struct stat statbuf;
						string ren = cur_name;
						
						while(1)
						{
							if (InputBox(	gettext("Rename"),
											ren) < 0) goto askagain;
							
							target_name = tcur_path + ren;
														
							if (lstat(target_name.c_str(), &statbuf) != -1)
							{
								MsgBox(	gettext("Error"), gettext("File exists"));
								continue;
							}
							
							break;
						}
						
					}
					
					case 3: // overwriteall
						bOverwriteAll = true;
						break;
						
					case 4: // skipall
						bSkipAll = true;
						p_size += src_stat.st_size;
						p++;
						continue;
							
					case 5: // cancel
						goto halt;
							
					default:
						break;
				}
			}
		}
		
		c_size=0;	
		// 실제 복사 오퍼레이션	
		
		p++;
		
		if (src_stat.st_ino == tar_stat.st_ino) continue;		
		
		fp = fopen(source_name.c_str(), "rb");
		out = fopen(target_name.c_str(), "wb");
		
		if (fp && out)	
		{
			nodelay(stdscr, TRUE); // esc키 처리//
			
			while( !feof(fp) )
			{
				key=getch();
							
				if (key!=-1)
				{
					nodelay(stdscr, FALSE);
					if (YNBox(gettext("Do you want to stop copy operation?"), YN_N)==YN_Y)
						goto halt;					
					s.redraw();
				}				
				
				last_size = fread(buf, 1, 65536, fp);
				fwrite(buf, 1, last_size, out);
				
				c_size +=last_size;
				p_size +=last_size;
				
				rest_size = toregular(p_size);
				
				s.setUR(rest_size.c_str());
				
				if (src_stat.st_size) 
					s.setU(c_size * 60 / src_stat.st_size);
				
				if (size) 
					s.setB(p_size * 60 / size);
				
				s.show();
			}
			nodelay(stdscr, FALSE); //다시 원상복구
		}
		else
		{
			if (YNBox(gettext("File access error, continue?"), YN_N) == YN_N) break;	
			continue;
		}
		
		fclose(out);
		fclose(fp);
		
		chmod(target_name.c_str(), permission);			
	}
halt:
	
	delete []buf;
	return 1;
}


///	\brief	파일을 복사한다.
///	\return	-1 : 복사실패\n
///			1 : 복사 성공
int Panel::cmd_copy()
{
	DirMcd mcd("", gettext(	"Select the directory where you want to copy these files"));
	
	mcd.AddDirectory(_path);
	mcd.setCur(_path);
	int  nRt = 0;
	
	do
	{
		if (mcd.proc())
		{
			if ((nRt = access(mcd.getCur().c_str(), R_OK | W_OK)) == -1)
				MsgBox(	gettext("Error"), strerror(errno));
		}
		else
			return -1;
	}
	while(nRt == -1);
	
	Selection sel = GetSelection();
	
	return Copy (sel, mcd.getCur());
		
	//Copy
}


