///	\file	panel_remove.cpp
///	\brief	panel_remove.cpp

//#include <sstream>
#include "panel.h"
#include "dialog.h"
#include "strutil.h"
#include "mlslocale.h"

using namespace std;
using namespace MLS;
using namespace strutil;

int Panel::cmd_zip_remove(void)
{
	int yn=YNBox(gettext(	"Do you want to remove files ?"), YN_N);
	
	if (yn == YN_Y)
	{
		WINDOW*	pWin = MsgWaitBox(	gettext("Wait"), 
									gettext("Please wait !!!"));
		
		int size = 0;
		Selection sel = GetSelection();
		vector<string> unzip_files=sel.GetData();		
		
		if (_tReader->Remove(unzip_files) == ERROR)
		{
			if (pWin) MsgWaitEnd(pWin);
			MsgBox(	gettext("Error"), 
					gettext("Remove Failure !!!"));
			return ERROR;
		}
		
		if (pWin) MsgWaitEnd(pWin);
		MsgBox(	gettext("Message"), 
				gettext("Remove Success !!!"));
		Refresh(true);
	}
	return SUCCESS;
}

int Panel::cmd_remove(void)
{// 현재디렉토리에서 파일을 지워버립니다... 주의 지금 현재디렉토리에 대한 명시적인 해석이 없음	
	// 지우기 전에 확인. 하는 과정..
	if (YNBox(
			gettext("Delete ?"), 
			YN_N, COLOR_RED) == YN_N) return 0;	
	
	StatBox s(gettext("Delete"), "");
	
	s.setUL(gettext("Counting files..."));
	s.show();
	
	int count_file = 0;
	//ostringstream BL;
	char	BL[1024];
	
	Selection files = GetSelection();	// 디렉토리까지..	
	files.ExpandDir(); // 디렉토리까지		
	
	vector<string> dir_stack;	
	
	string p = toregular(files.GetSize());	
		
	s.setBR(p.c_str());	
	string tar_dir; // 현재 타겟 디렉토리
	
	//for (i = files.begin(); i != end; ++i)
	//	LOG("%s", (*i).c_str());
	
	for (int t = 0; t<files.Size(); ++t)
	{
		const string &rf = files[t];
		
		if (rf.empty()) continue;
		
		// 상대가 디렉토리 라면..		
		if (*rf.rbegin() == '/')  
		{
			while(!dir_stack.empty())
			{
				//if (!rf.compare (0, dir_stack.back().size(), dir_stack.back()))
				if (rf.substr(0, dir_stack.back().size()) == dir_stack.back())
						break;				
				
				//BL.str("");
				//BL << '<' << count_file << '/' << files.size() << '>' ;
				sprintf(BL, "<%ld/%ld>", count_file, files.Size());
				
				s.setU(0);				
				s.setUL(dir_stack.back().c_str());
				s.setBL(BL);	
				s.show();
				
				if (remove(dir_stack.back().c_str()))
				{
					MsgBox(COLOR_RED, gettext("ERROR"), 
									gettext("Remove Failure !!! %s"),
									(dir_stack.back().c_str()));
					return 1;					
				}
				count_file++;
				
				s.setU(60);
				s.setB(count_file*60/files.Size());
				s.show();
				
				dir_stack.pop_back();			
			}
			dir_stack.push_back(rf.substr(0, rf.size()-1));
			tar_dir = rf;
		}		
		else
		{ // 파일을 지운다.
			//BL.str("");
			//BL << '<' << count_file << '/' << files.size() << '>' ;
			
			sprintf(BL, "<%ld/%ld>", count_file, files.Size());
			
			s.setU(0);				
			s.setUL((tar_dir + rf).c_str());
			//s.setBL(BL.str().c_str());								
			s.setBL(BL);
			s.show();
			
			if (remove((tar_dir + rf).c_str()))
			{	
				MsgBox(COLOR_RED, gettext("ERROR"), 
								gettext("Remove Failure !!! %s"), 
								(tar_dir + rf).c_str());
				break;
			}
			count_file++;
			
			s.setU(60);
			s.setB(count_file*60/files.Size());
			s.show();			
			
		}	
	}
	
	// 남은 디렉토리 정리	
	while(!dir_stack.empty())
	{		
		//BL.str("");
		//BL << '<' << count_file << '/' << files.size() << '>' ;		
		sprintf(BL, "<%ld/%ld>", count_file, files.Size());
		
		s.setU(0);				
		s.setUL(dir_stack.back().c_str());
		//s.setBL(BL.str().c_str());								
		s.setBL(BL);
		s.show();
		
		if (remove(dir_stack.back().c_str()))
		{
			MsgBox(COLOR_RED, gettext("ERROR"), 
								gettext("Remove Failure !!! %s"),  dir_stack.back().c_str());
			return 1;					
		}
		count_file++;
		
		s.setU(60);
		s.setB(count_file*60/files.Size());
		s.show();
		
		dir_stack.pop_back();
	}
	
	Refresh();
	return 0;
}

