                  /*
  The osipua library is a library based on oSIP that implements CallLeg and User Agent
  level.
  Copyright (C) 2001  Simon MORLAT simon.morlat@free.fr
  											Aymeric MOIZARD jack@atosc.org
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "osipua.h"

/**
 * registration_ctxt_new:
 *
 * Creates a new #RegistrationCtxt (registration context) to be used with #osip_call_leg_register().
 *
 * Returns: a new registration context.
 */
RegistrationCtxt *registration_ctxt_new()
{
	RegistrationCtxt *new_ctx;
	new_ctx=smalloc(sizeof( RegistrationCtxt));
	memset(new_ctx,0,sizeof(RegistrationCtxt));
	new_ctx->ref_count=1;
	return new_ctx;
}
/**
 * registration_ctxt_set_registrar:
 * @ctxt: a RegistrationCtxt object.
 * @registrar: the sip url of a registrar.
 *
 *	Sets the registrar address.
 *
 */
void registration_ctxt_set_registrar(RegistrationCtxt *ctxt, char *registrar)
{
	if ( ctxt->registrar!=NULL) sfree(ctxt->registrar);
	if (registrar==NULL) {
		ctxt->registrar=NULL;
		return;
	}
	ctxt->registrar=sgetcopy(registrar);
}
/**
 * registration_ctxt_set_password:
 * @ctxt: a RegistrationCtxt object.
 * @password: the password to be used for registration.
 *
 *	Sets the password to be used for the registration (can be NULL).
 *
 */
void registration_ctxt_set_password(RegistrationCtxt *ctxt, char *password)
{
	if ( ctxt->password!=NULL) sfree(ctxt->password);
	if (password==NULL) {
		ctxt->password=NULL;
		return;
	}
	ctxt->password=sgetcopy(password);
}
/**
 * registration_ctxt_address_of_record:
 * @ctxt: a RegistrationCtxt object.
 * @addr_of_rec: an address of record to be used for the registration.
 *
 * Sets the address of record to be used for the registration. If NULL, the from field
 * of the call-leg will be used instead.
 *
 */
void registration_ctxt_set_address_of_record(RegistrationCtxt *ctxt, char *addr_of_rec)
{
	if ( ctxt->address_of_record!=NULL) sfree(ctxt->address_of_record);
	if (addr_of_rec==NULL) {
		ctxt->address_of_record=NULL;
		return;
	}
	ctxt->address_of_record=sgetcopy(addr_of_rec);
}

#if 0
RegistrationCtxt * registration_ctxt_dup(  RegistrationCtxt *ctxt)
{
	RegistrationCtxt *new_ctx;
	if (ctxt->registrar==NULL) return NULL;
	new_ctx=smalloc(sizeof( RegistrationCtxt));
	/* copy registrar name */
	new_ctx->registrar=sgetcopy(ctxt->registrar);
	/* copy password */
	if (ctxt->password!=NULL)  new_ctx->password=sgetcopy(ctxt->password);
	else  new_ctx->password=NULL;
	/* copy address of record */
	if (ctxt->address_of_record!=NULL)  new_ctx->address_of_record=sgetcopy(ctxt->address_of_record);
	else new_ctx->address_of_record=NULL;
	/* copy expires */
	new_ctx->expires=ctxt->expires;
	new_ctx->callid_number = NULL;  /* ?? */
	new_ctx->cseq_number   = 0;  /* ?? */
	return new_ctx;
}
#endif

/**
 *  registration_ctxt_destroy:
 * @ctx: a registration context.
 *
 * Destroys a registration context.
 *
 */
void registration_ctxt_destroy( RegistrationCtxt *ctx)
{
	ctx->ref_count--;
	if (ctx->ref_count==0)  registration_ctxt_free(ctx);
}

void registration_ctxt_free(RegistrationCtxt *ctx)
{
        if (ctx==NULL) return ;
	sfree(ctx->registrar);
	sfree(ctx->password);
	sfree(ctx->address_of_record);
	sfree(ctx->callid_number);
	sfree(ctx);	
}
