/***************************************************************************
                          crxwindow.h  -  description
                             -------------------
    begin                : Mon Mar 6 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef CRXWINDOW_H
#define CRXWINDOW_H

#include <qscrollview.h>
#include "constants.h"
#include "qsoinfo.h"
#include <qfile.h>
#include <qtextstream.h>
class QLineEdit;
class QVBox;
class QWidget;
class QString;

class CRxWindow : public QScrollView
{
    Q_OBJECT

public:
    CRxWindow( QWidget* parent = 0, const char* name = 0 );
    ~CRxWindow();
  bool getTriggerStatus();
  QString getTriggerText();
  void stopRecording();
  void startRecording(QString);
  bool getRecordingState();
public slots:
    void updateRx(char);
    void clearRxWindow();
    void setColor(QColor);
    void activateTrigger(QString);
    void deactivateTrigger();

protected:
virtual void fontChange(const QFont &);


protected slots:

private:

QLineEdit* ScrollBuffer[RxWindowBuffer];
int Row,Column;
void RemoveFirstLine();
void NeueZeile();
QVBox* DisplayBox;
bool AutoScroll;
bool trigger;
QString TriggerText;
QString TexttoTrigger;
bool save;
QFile File;
QTextStream *stream;
signals:
void Triggered();
};

#endif // CRXWINDOW_H
