/***************************************************************************
                          csound.h  -  description
                             -------------------
    begin                : Wed Apr 5 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef CSOUND_H
#define CSOUND_H

#ifndef LINPSK_FOR_MAC
#include <sys/soundcard.h>
#endif

#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>


#include <qobject.h>

#include "input.h"
#include "constants.h"
/**Class for operating on SoundCard
  *@author Volker Schroer
  */

class CSound :public Input
{
public: 
	CSound(int ptt);
	~CSound();
	bool open_Device_write(QString Device);
#ifdef LINPSK_FOR_MAC
	bool open_Device_read(QString Device);
#endif
	bool close_Device();
	bool setParams(QString *errorstring);
  int getSamples(double *,int);				// Reading Samples from Soundcard
	int putSamples(double *,int);
	void PTT(bool);

private: // Private attributes
  /** Type of Operation Mono/Stereo */
  int mode;
  /** Audio Format **/
	int audioformat;
  /** Sampling rate */
   int speed;
	/** Fragmentsize for Soundcard IO */
	int fragsize;
	bool started;
	unsigned char *audio_buffer;
#ifdef LINPSK_FOR_MAC
	int filled;
#else
  audio_buf_info info;
#endif
};

#endif
