/***************************************************************************
                          |FILENAME|  -  description
                             -------------------
    begin                : |DATE|
    copyright            : (C) |YEAR| by |AUTHOR|
    email                : |EMAIL|
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *   The PSK part is based on WinPSK 1.0 by Moe Wheatly, AE4JY             *
 ***************************************************************************/
#include "frequencyselect.h"

#include <qvariant.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qlayout.h>

/* 
 *  Constructs a FrequencySelect which is a child of 'parent', with the 
 *  name 'name'.' 
 */
FrequencySelect::FrequencySelect( QWidget* parent,  const char* name )
    : QGroupBox( parent, name )
{
    setFrameShape( QGroupBox::WinPanel );
    setFrameShadow( QGroupBox::Raised );
    setAlignment( int( QGroupBox::AlignCenter ) );

    Activate = new QRadioButton( this, "Activate" );

    Frequency = new QSpinBox( this, "Frequency" );
    Frequency->setMaxValue( 2500 );
    Frequency->setMinValue( 300 );
    frequency = 1000;
    Frequency->setValue( (int) frequency );
    languageChange();
    connect(Frequency,SIGNAL(valueChanged(int)),this,SLOT(checkFrequency(int)));
    connect(Activate,SIGNAL(toggled(bool)),this,SIGNAL(toggleAFC(bool)));
}

/*
 *  Destroys the object and frees any allocated resources
 */
FrequencySelect::~FrequencySelect()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void FrequencySelect::languageChange()
{
    Activate->setText( tr( "Frequency" ) );
}


double FrequencySelect::getFrequency()
{
return frequency;
}


void FrequencySelect::setFunctionText( QString Text)
{
Activate->setText(Text);
}



void FrequencySelect::calculateSizeofComponents()
{
#define LEFTANDRIGHTMARGIN 10
#define TOPANDBOTTOM 30
#define LABELHEIGHT 30
int width,height,xpos,ypos,innerwidth,innerheight;
width=this->width();
height=this->height();
xpos=width*LEFTANDRIGHTMARGIN/100;
ypos=height*TOPANDBOTTOM/100;
innerwidth=width-2*xpos;
innerheight=height*LABELHEIGHT/100;
Frequency->setGeometry(xpos,ypos,innerwidth,innerheight);
ypos=ypos+innerheight;
Activate->setGeometry(xpos,ypos,innerwidth,innerheight);
setFrameRect(QRect(0,0,width,height));

}

void FrequencySelect::resizeEvent( QResizeEvent * )
{
calculateSizeofComponents();
}


void FrequencySelect::setFrequency( double freq)
{
Frequency->setValue( (int) freq);
frequency=freq;
}

void FrequencySelect::checkFrequency(int freq)
{
if ((unsigned int) freq != (unsigned int)frequency)
  {
   frequency= freq;  
   emit FrequencyChanged(frequency);
  }
}

bool FrequencySelect::State()
{
return Activate->isOn();
}

void FrequencySelect::setState(bool OnOff)
{
Activate->setChecked(OnOff);
}
