/***************************************************************************
                          fskdemodulator.h  -  description
                             -------------------
    begin                : Fre Jan 31 2003
    copyright            : (C) 2003 by Volker Schroer
    email                : dl1ksv@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *   The PSK part is based on WinPSK 1.0 by Moe Wheatley, AE4JY            *              
 ***************************************************************************/

#ifndef FSKDEMODULATOR_H
#define FSKDEMODULATOR_H

#include <cdemodulator.h>
#include <complex>

using namespace std;
#include "constants.h"

/**Base Class for FSK Demodulation like RTTY and MFSK
  *@author Volker Schroer
  */

class FSKDemodulator : public CDemodulator  {
public: 
	FSKDemodulator();
	~FSKDemodulator();
//bool init(double,int);
protected:
//int NumberofTones;
float Baudrate;
unsigned int SymbolLength;
/** coeficients for slidding fft */
complex<double> *twiddles;
/** result of slidding fft for the different tones */
complex<double> *bins;
/** Hilbert Transformer **/
complex<double> Hilbert(double);


private: 	//Private Variables

int Filterptr;
double FilterBuffer[HilbertFilterLength];
/** Coefficients for Hilber Transformer **/
complex<double> filter[HilbertFilterLength];
void init_filter(double,double);
double cosc(double);
double sinc(double);
double hamming(double);
};

#endif
