/***************************************************************************
                          macros.cpp  -  description
                             -------------------
    begin                : Sam Mai 3 2003
    copyright            : (C) 2003 by Volker Schroer
    email                : dl1ksv@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "macrowindow.h"
#include <qpushbutton.h>
#include <qbuttongroup.h>

#include "macros.h"

MacroWindow::MacroWindow(QWidget *parent, const char *name ) : QScrollView(parent,name)
{
DisplayBox=new QButtonGroup(1,Horizontal,viewport());
DisplayBox->setMargin(0);
DisplayBox->setLineWidth(0);
DisplayBox->setMidLineWidth(0);
addChild(DisplayBox);
setResizePolicy(AutoOne);
verticalScrollBar()->setFixedWidth(16);
setVScrollBarMode(AlwaysOn);
setHScrollBarMode(AlwaysOff);
horizontalScrollBar()->setFixedHeight(16);
connect(DisplayBox,SIGNAL(clicked(int)),this,SIGNAL(callMacro(int)));
}
MacroWindow::~MacroWindow(){
}
void MacroWindow::resizeEvent( QResizeEvent * )
{
int width,y;
int anzahl = DisplayBox->count();
width=this->width();
width=width-verticalScrollBar()->width();

DisplayBox->setFixedWidth(width);
width=width-15;
y=5;
for(int i=0; i < anzahl; i++)
 {
  QButton *pb; 
  pb=DisplayBox->find(i);
  pb->setGeometry(5,y,width,20);
  y=y+25;
 } 
}
void MacroWindow::updateMacroWindow(Macros *Macro)
{
QButton *pb;
int anzahl = DisplayBox->count();
int i;

for(i=0; i < anzahl; i++)
 {
  pb=DisplayBox->find(i);
  DisplayBox->remove(pb);
  delete pb;
 }
anzahl= Macro->MacroNames.size();  
for(i=0; i< anzahl;i++)
 {
  pb = new QPushButton(DisplayBox);

  if ( !Macro->Accelerator[i].isEmpty() )
   {
    pb->setAccel(QKeySequence(Macro->Accelerator[i]));
    pb->setText(Macro->MacroNames[i]+" ("+Macro->Accelerator[i]+")");    
   } 
  else
     pb->setText(Macro->MacroNames[i]); 
  pb->show();
 }
show(); 
}

