/***************************************************************************
                          utils.cpp  -  description
                             -------------------
    begin                : Fri Apr 18 2003
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *    based on the work of  Moe Wheatly, AE4JY                             *
 ***************************************************************************/

#include "utils.h"
#ifndef LINPSK_FOR_MAC
#include <linux/serial.h>
#include <sys/soundcard.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#endif

void setVolume(int Device,int Volume)
{
#ifndef LINPSK_FOR_MAC
int fd;
int ii;

fd=open("/dev/mixer",O_RDWR);
if  (fd >0)
	{
    ii=(1 << Device);
  	ioctl(fd,MIXER_WRITE(SOUND_MIXER_RECSRC),&ii);
		ii = Volume & 0x7f;
		ioctl(fd,MIXER_WRITE(Device),&ii);
		close(fd);
	}
#endif
}
void setOutputVolume(int Level)
{
#ifndef LINPSK_FOR_MAC
setVolume(MIXER_WRITE(SOUND_MIXER_VOLUME),Level);
#endif
}

bool checkcom(const char* s)
{

#ifdef LINPSK_FOR_MAC
return false;
#else
int fd;

struct serial_struct serinfo;


fd=open(s,O_RDWR|O_NONBLOCK);

if (fd <0)

return false;

serinfo.reserved_char[0] = 0;
if (ioctl(fd, TIOCGSERIAL, &serinfo) < 0)
	{
	close(fd);
	return false;
	}
close(fd);
if ( serinfo.type == 5 || serinfo.type ==0 )
return false;
else
return true;
#endif
}
