/*
 *  callbacks.c: event and signal handlers
 *
 *  Copyright (C) 1997-2005 John Coppens (john@jcoppens.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <complex.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "main.h"
#include "global.h"
#include "chart.h"
#include "element.h"
#include "load.h"
#include "aux.h"


//=====================================================================
//      Auxiliary callbacks
//=====================================================================

void
on_circuitfile_load_selected(GtkButton *button, gpointer user_data)
{
  strcpy(pref.last_el_file,
         gtk_file_selection_get_filename(GTK_FILE_SELECTION(user_data)));
  load_circuit(pref.last_el_file);
  save_file_paths();
}

void
on_circuitfile_save_selected(GtkButton *button, gpointer user_data)
{
  strcpy(pref.last_el_file,
         gtk_file_selection_get_filename(GTK_FILE_SELECTION(user_data)));
  save_circuit(pref.last_el_file);
  save_file_paths();
}

void
on_loadfile_load_selected(GtkButton *button, gpointer user_data)
{
  strcpy(pref.last_ld_file,
         gtk_file_selection_get_filename(GTK_FILE_SELECTION(user_data)));
  load_loads(pref.last_ld_file);
  save_file_paths();
}

void
on_loadfile_save_selected(GtkButton *button, gpointer user_data)
{
  strcpy(pref.last_ld_file,
         gtk_file_selection_get_filename(GTK_FILE_SELECTION(user_data)));
  save_loads(pref.last_ld_file);
  save_file_paths();
}

//=====================================================================
//	Main menu
//=====================================================================

//	File menu item
//	Circuit:

void
on_load3_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  create_filedialog(_("Load a circuit"), pref.last_el_file,
                    on_circuitfile_load_selected, "*.circ");
}


void
on_save4_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (strlen(pref.last_el_file) != 0)
    save_circuit(pref.last_el_file);
  else
    on_save_as4_activate(menuitem, user_data);
}


void
on_save_as4_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  create_filedialog(_("Save circuit as"), pref.last_el_file,
                    on_circuitfile_save_selected, "*.circ");
}

//	Loads:

void
on_load4_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  create_filedialog(_("Load load impedances"), pref.last_ld_file,
                    on_loadfile_load_selected, "*.load");
}


void
on_save5_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (strlen(pref.last_ld_file) != 0)
    save_loads(pref.last_ld_file);
  else
    on_save_as3_activate(menuitem, user_data);
}


void
on_save_as3_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  create_filedialog(_("Save load impedances as"), pref.last_ld_file,
                    on_loadfile_save_selected, "*.load");
}


void
on_export_postscript1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  recalculate_all_export();
}


void
on_quit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gtk_main_quit();
}

//	Edit menu items

void
on_preferences1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *w = create_ConfigWindow();
  gtk_widget_show(w);
}

//	View menu items

void
on_recalculate1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}

//	Help menu item

void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_about();
}

//---------------------------------------------------------------------
//	Other MainWindow events
//---------------------------------------------------------------------

gboolean
on_MainWindow_delete_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_main_quit();
  return FALSE;
}


void
on_MainWindow_realize                  (GtkWidget       *widget,
                                        gpointer         user_data)
{
  initialize_MainWindow();
  initialize_elementtable();
  initialize_loadtable();
}


void
on_z0_entry_changed                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  update_chart_z0;
  save_config();
}


void
on_zoom_out_btn_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  change_zoom(ZOOM_OUT);
}


void
on_zoom_in_btn_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  change_zoom(ZOOM_IN);
}


//---------------------------------------------------------------------
//      Main window, CHART events
//---------------------------------------------------------------------

void
on_canvas1_realize                     (GtkWidget       *widget,
                                        gpointer         user_data)
{
  chart_initialize();
}


gboolean
on_chart_canvas_motion_notify_event    (GtkWidget       *widget,
                                        GdkEventMotion  *event,
                                        gpointer         user_data)
{
  if (event->device->source == GDK_SOURCE_MOUSE) {
    update_cursor_values(event->x, event->y);
  }
  return FALSE;
}

//---------------------------------------------------------------------
//      Main page notebook
//---------------------------------------------------------------------

void
on_circuit_notebook_realize            (GtkWidget       *widget,
                                        gpointer         user_data)
{

}

//	LOAD page

void
on_load_treeview_cursor_changed        (GtkTreeView     *treeview,
                                        gpointer         user_data)
{
  on_load_selected(treeview);
}


void
on_load_append_btn_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  if (load_valid()) load_append();
}


void
on_load_remove_btn_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  active_load_remove();
}


void
on_load_edit_btn_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  if (load_valid()) active_load_update();
}


void
on_load_rx_rbtn_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_load_rang_rbtn_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_comp_stub_selcable_btn_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *btn, *w = create_CableWindow();
  btn = lookup_widget(w, "cable_accept_btn");
  g_object_set_data(G_OBJECT(btn), "caller", GINT_TO_POINTER(SEP_STUB_VAL));
  gtk_widget_show(w);
}


void
on_comp_line_selcable_btn_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *btn, *w = create_CableWindow();
  btn = lookup_widget(w, "cable_accept_btn");
  g_object_set_data(G_OBJECT(btn), "caller", GINT_TO_POINTER(SEP_LINE_VAL));
  gtk_widget_show(w);
}


//	CIRCUIT page

void
on_circ_newel_btn_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  el_definition el;
  if (element_valid(&el)) element_append(el);
}


void
on_circ_upd_el_btn_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  el_definition el;
  if (element_valid(&el)) element_update(el);
  gtk_widget_set_sensitive(GTK_WIDGET(button), FALSE);
}


void
on_circ_delete_btn_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  active_element_remove();
}


void
on_circ_up_btn_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  circ_move_up();
}


void
on_circ_down_btn_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  circ_move_down();
}


void
on_circ_treeview_cursor_changed        (GtkTreeView     *treeview,
                                        gpointer         user_data)
{
  fetch_selected_element(treeview, &act_el);
  recalculate_all();
}


void
on_recalc_btn_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  recalculate_all();
}

//=====================================================================
//      Config menu
//=====================================================================

void
on_conf_cancel_btn_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(lookup_widget(GTK_WIDGET(button), "ConfigWindow"));
}


void
on_conf_ok_btn_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  parse_configwindow(GTK_WIDGET(button));
  save_config();
  draw_swr_circle(pref.swr_circle);
  gtk_widget_destroy(lookup_widget(GTK_WIDGET(button), "ConfigWindow"));
}


void
on_ConfigWindow_realize                (GtkWidget       *widget,
                                        gpointer         user_data)
{
  load_configwindow(widget);
  print_load_font_list(GTK_COMBO(lookup_widget(widget, "prt_font_combo")));
}


gboolean
on_ConfigWindow_destroy_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_confrem_enable_cbtn_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  set_remote_enabled(GTK_WIDGET(button),
                     gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)));
}


void
on_log_treeview_realize                (GtkWidget       *widget,
                                        gpointer         user_data)
{
  loglist_initialize(GTK_TREE_VIEW(widget));
}

void
on_notebook4_realize                   (GtkWidget       *widget,
                                        gpointer         user_data)
{
  gtk_widget_realize(lookup_widget(MainWindow, "log_treeview"));
}


void
on_save_as_postscript1_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_prt_font_picker_font_set            (GnomeFontPicker *fontpicker,
                                        gchar           *font_name,
                                        gpointer         user_data)
{
  GtkWidget *w = lookup_widget(GTK_WIDGET(fontpicker), "prt_font_entry");

  gtk_entry_set_text(GTK_ENTRY(w), font_name);
}


void
on_comp_xform_entry_changed            (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget *w = lookup_widget(MainWindow, "circ_edit_btn");

  g_signal_emit_by_name(G_OBJECT(w), "clicked", NULL);
}


void
on_load_getrem_btn_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
}

//================== Test only ===================================

void
on_test1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  test_routine();
}


void
on_CableWindow_realize                 (GtkWidget       *widget,
                                        gpointer         user_data)
{
  load_cable_table(widget);
}


void
on_cable_view_cursor_changed           (GtkTreeView     *treeview,
                                        gpointer         user_data)
{
  GtkWidget *btn = lookup_widget(GTK_WIDGET(treeview), "cable_accept_btn");
  GtkTreeSelection *sel = gtk_tree_view_get_selection(treeview);
  GtkTreeModel *model;
  GtkTreeIter iter;
  int cable;

  gtk_tree_selection_get_selected(sel, &model, &iter);
  gtk_tree_model_get(model, &iter, 7, &cable, -1);
  g_object_set_data(G_OBJECT(btn), "cable", GINT_TO_POINTER(cable));
}


void
on_cable_cancel_btn_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(lookup_widget(GTK_WIDGET(button), "CableWindow"));
}


void
on_cable_accept_btn_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *wdw = lookup_widget(GTK_WIDGET(button), "CableWindow");
  int which = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(button), "caller"));
  int cable = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(button), "cable"));

  show_cable_data(which, cable);
  gtk_widget_destroy(wdw);
}


void
on_save_results_page1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}

