/*
 *  log.c: Log generation
 *
 *  Copyright (C) 1997-2005 John Coppens (john@jcoppens.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <complex.h>

#include "support.h"
#include "main.h"
#include "global.h"
#include "log.h"

#define  LOGFONT	"Courier 12"

GtkTreeView	*logview = NULL;

struct {
  int nr_lds, nr_els;
  complex *val;
  GtkListStore *store;
} loglist = {
  0, 0,
  NULL,
  NULL
};


void
loglist_initialize(GtkTreeView *tview)
{
  GtkTreeViewColumn *col;
  GtkCellRenderer *renderer;
  GtkTreeIter iter;
  int c;

  logview = tview;
  loglist.store = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_STRING);
  gtk_tree_view_set_model(GTK_TREE_VIEW(logview),
			GTK_TREE_MODEL(loglist.store));
  for (c = 0; c < 2; c++) {
    renderer = gtk_cell_renderer_text_new();
    gtk_object_set(GTK_OBJECT(renderer),
			"font", LOGFONT,
			"height", 16,
			NULL);
    col = gtk_tree_view_column_new_with_attributes("",
			renderer, "text", c, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(logview), col);
  }
  g_object_unref(loglist.store);
}


void
loglist_create(int nr_lds, int nr_els)
{
  if (loglist.val) g_free(loglist.val);
  loglist.val = malloc(sizeof(complex) * nr_lds * (2*nr_els + LOG_OVERHEAD));
  loglist.nr_lds = nr_lds;
  loglist.nr_els = nr_els;
}


void
loglist_set_value(int ldnr, int linenr, complex value)
{
  loglist.val[linenr * loglist.nr_lds + ldnr] = value;
}


void
loglist_show(void)
{
  GtkTreeIter iter;
  GtkTreeViewColumn *col;
  GtkWidget *w;
  char bff[50], elref[10], row[300];
  int ld, el;
  complex c;

  gtk_list_store_clear(loglist.store);

  sprintf(row, "<span font_desc=\"%s\">%s</span>", LOGFONT, _("Freq"));
  col = gtk_tree_view_get_column(logview, 0);
  w = gtk_label_new("");
  gtk_widget_show(w);
  gtk_label_set_markup(GTK_LABEL(w), row);
  gtk_tree_view_column_set_widget(col, w);

  sprintf(row, "<span font_desc=\"%s\">", LOGFONT);
  for (ld = 0; ld < loglist.nr_lds; ld++) {
    sprintf(bff, "   %9.*f MHz    ", pref.prec_mhz, creal(loglist.val[ld]));
    strcat(row, bff);
  }
  strcat(row, "</span>");
  col = gtk_tree_view_get_column(logview, 1);
  w = gtk_label_new("");
  gtk_widget_show(w);
  gtk_label_set_markup(GTK_LABEL(w), row);
  gtk_tree_view_column_set_widget(col, w);

  row[0] = '\0';
  for (ld = 0; ld < loglist.nr_lds; ld++) {
    c = loglist.val[loglist.nr_lds + ld];
    sprintf(bff, "%9.3f%+9.3f%s ", creal(c), cimag(c), pref.complex_sfx);
    strcat(row, bff);
  }
  gtk_list_store_append(loglist.store, &iter);
  gtk_list_store_set(loglist.store, &iter,
                0, _("Load"),
                1, row,
                -1);

  for (el = 0; el < loglist.nr_els; el++) {
    row[0] = '\0';
    for (ld = 0; ld < loglist.nr_lds; ld++) {
      c = loglist.val[(2*el + LOG_OVERHEAD) * loglist.nr_lds + ld]; 
      sprintf(bff, "%9.3f%+9.3f%s ", creal(c), cimag(c), pref.complex_sfx);
      strcat(row, bff);
    }
    sprintf(elref, _("El %d"), el+1);
    gtk_list_store_append(loglist.store, &iter);
    gtk_list_store_set(loglist.store, &iter,
		0, elref,
		1, row, -1);

    row[0] = '\0';
    for (ld = 0; ld < loglist.nr_lds; ld++) {
      c = loglist.val[(2*el + 1 + LOG_OVERHEAD) * loglist.nr_lds + ld];
      sprintf(bff, "%9.3f%+9.3f%s ", creal(c), cimag(c), pref.complex_sfx);
      strcat(row, bff);
    }
    gtk_list_store_append(loglist.store, &iter);
    gtk_list_store_set(loglist.store, &iter,
                0, "",
                1, row, -1);
  }
}
