/*
 *
 * Linup - Uptimes Project Client for Linux
 * Copyright (C) 2002  Joao Sena Ribeiro
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "linup.h"

/* base64_encode(char*, char*, int) -> (void)
 *
 * This function encodes a string using base64. It's used for
 * proxy authentication on the sendinfo() function.
 *
 * This code was found on the Internet. It's apparent author is
 * one "ari edelkind", whose page you can see on
 * http://www.episec.com/people/edelkind/. Sorry, but I wasn't
 * able to find anything else about him.
 *
 */
void base64_encode(char *to, char *from, int len) {
  char *fromp = from;
  char *top = to;
  unsigned char cbyte;
  unsigned char obyte;
  char end[3];
  char b64string[] =
    "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

  for(; len >= 3; len -= 3) {
    cbyte = *fromp++;
    *top++ = b64string[(int) (cbyte >> 2)];
    obyte = (cbyte << 4) & 0x30;              /* 0011 0000 */

    cbyte = *fromp++;
    obyte |= (cbyte >> 4);                    /* 0000 1111 */
    *top++ = b64string[(int) obyte];
    obyte = (cbyte << 2) & 0x3C;              /* 0011 1100 */

    cbyte = *fromp++;
    obyte |= (cbyte >> 6);                    /* 0000 0011 */
    *top++ = b64string[(int) obyte];
    *top++ = b64string[(int) (cbyte & 0x3F)]; /* 0011 1111 */
  }

  if(len) {
    end[0] = *fromp++;
    if(--len)
      end[1] = *fromp++;
    else
      end[1] = 0;
    end[2] = 0;

    cbyte = end[0];
    *top++ = b64string[(int) (cbyte >> 2)];
    obyte = (cbyte << 4) & 0x30;              /* 0011 0000 */

    cbyte = end[1];
    obyte |= (cbyte >> 4);
    *top++ = b64string[(int) obyte];
    obyte = (cbyte << 2) & 0x3C;              /* 0011 1100 */

    if(len)
      *top++ = b64string[(int) obyte];
    else
      *top++ = '=';
    *top++ = '=';
  }

  *top = 0;
}
