/*
 *
 * Linup - Uptimes Project Client for Linux
 * Copyright (C) 2002  Joao Sena Ribeiro
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "linup.h"
#include <unistd.h>

/* main(int, char**) -> int
 *
 * The main function.
 *
 */
int main(int argc, char *argv[]) {
  static char optstring[] = "hvf:a:p:u:l:o";
  int optch;
  char progname[BUFFSIZE], buff[BUFFSIZE];
  char os[MAXINFOLENGTH], oslevel[MAXINFOLENGTH], cpu[BUFFSIZE];
  char auth[33] = "NO AUTH FILE";
  long int uptime = 0;
  float load = 0.00;
  int idle = 100;
  int useauthfile = 0;
  char authfile[BUFFSIZE];
  int useproxy = 0, useproxyauth = 0, proxyport = 0;
  char proxy[BUFFSIZE], proxyauth[BUFFSIZE];
  int useoldproto = 0;

  strncpy(progname, argv[0], sizeof(progname));

  while((optch = getopt(argc, argv, optstring)) != EOF)
    switch(optch) {
      case 'h': help_message(progname);
                exit(EXIT_FAILURE);
      case 'v': version_message();
                exit(EXIT_FAILURE);
      case 'f': strncpy(authfile, optarg, sizeof(authfile));
                useauthfile = 1;
                break;
      case 'a': set_auth(progname, auth, sizeof(auth), optarg);
                break;
      case 'p': strncpy(proxy, optarg, sizeof(proxy));
                useproxy = 1;
                break;
      case 'u': strncpy(proxyauth, optarg, sizeof(proxyauth));
                useproxyauth = 1;
                break;
      case 'l': sscanf(optarg, "%d", &proxyport);
                break;
      case 'o': useoldproto = 1;
                break;
      default : help_message(progname);
                exit(EXIT_FAILURE);
    }

  if(!strcmp(auth, "NO AUTH FILE") && !useauthfile) {
    help_message(progname);
    exit(EXIT_FAILURE);
  }

  if(useauthfile)
    read_auth(progname, auth, sizeof(auth), authfile);

  get_most_info(progname, &uptime, &load, os, oslevel, cpu);
  get_idle(progname, &idle);

  /* Using old (TCP-based) protocol? */
  if(useoldproto) {
    snprintf(buff, sizeof(buff),
        "auth=%s&uptime=%ld&load=%.2f&idle=%d&os=%s&oslevel=%s&cpu=%s",
        auth, uptime, load, idle, os, oslevel, cpu);
    send_info_tcp(progname, buff, useproxy, proxy,
        useproxyauth, proxyauth, proxyport);
  } else {
    snprintf(buff, sizeof(buff),
        "%s|%ld|%.2f|%d|%s|%s|%s|upclient/5.0/%s-%s",
        auth, uptime, load, idle, os, oslevel, cpu, PROGNAME, VERSION);
    send_info_udp(progname, buff);
  }

  /* Error checking is made by other functions, so if control   *
   * reaches here (the end of the function), exit with runlevel *
   * EXIT_SUCCESS.                                              */
  return EXIT_SUCCESS;
}
