/*
 *
 * Linup - Uptimes Project Client for Linux
 * Copyright (C) 2002  Joao Sena Ribeiro
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Program name, version and author. */
#define PROGNAME "linup"
#define VERSION "1.1.0"
#define AUTHOR "Joao Ribeiro <sena@smux.net>"

/* The uptimes project host. */
#define HOST "uptimes.wonko.com"
/* The port to use (80 is default for HTTP), with the old (4.20) protocol. */
#define PORT 80
/* The location of the document to where we should POST. */
#define LOCATION "/server.html"
/* The default Web Proxy port (3128, as used by Squid). */ 
#define DEFAULTPROXYPORT 3128
/* The port to use with protocol 5.0 (UDP). */
#define UDP_PORT 49153

/* Normal size of buffers. No need to make it bigger, although it *
 * could be smaller...                                            */
#define BUFFSIZE 1024
/* Maximum length of OS and OSLEVEL info (plus one for string *
 * termination). UP4 Protocol says OS should be 16, but it    *
 * doesn't specify OSLEVEL. We use 16 anyway.                 */
#define MAXINFOLENGTH 17
/* Location of the file we use to get Idle information. Location *
 * shouldn't change, but we make this a #define just in case.    */
#define PROC_UPTIME "/proc/uptime"

/* In file getkey.c */
extern void read_auth(char *progname, char *auth, int maximum, char *authfile);
extern void set_auth(char *progname, char *auth, int maximum, char *authstring);
extern void check_key(char *progname, char *key);

/* In file getinfo.c */
extern void get_most_info(char *progname, long *uptime, float *load, char *os,
    char *oslevel, char *cpu);
extern void get_idle(char *progname, int *idle);

/* In file sendinfo.c */
extern void send_info_tcp(char *progname, char *info, int useproxy, char *proxy,
    int useproxyauth, char *proxyauth, int proxyport);
extern void send_info_udp(char *progname, char *info);
extern void recon_resp(char *progname, char *response);

/* In file errors.c */
extern void crash(char *progname, char *arg);
extern void help_message(char *progname);
extern void version_message(void);

/* In file base64.c */
extern void base64_encode(char *to, char *from, int len);
