/*
 *   Copyright (C) 2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "FSKModem.h"

#include <cmath>
using namespace std;

#include <wx/log.h>
#include <wx/debug.h>

CFSKModem::CFSKModem(int mAry) :
m_mAry(mAry),
m_bitsPerSymbol(0),
m_bitMap()
{
	wxASSERT(mAry > 0);

	m_bitsPerSymbol = ::round_i(::log2(mAry));

	m_bitMap = ::graycode(m_bitsPerSymbol);
}

CFSKModem::~CFSKModem()
{
}

int* CFSKModem::modulate(int* bits) const
{
	wxASSERT(bits != NULL);

	// Rounnd up to the nearest divisible n-bit characters
	int nBitsOrig = bits.size();
	int nSymbols  = nBitsOrig / m_bitsPerSymbol;

	if ((nBitsOrig % m_bitsPerSymbol) != 0)
		nSymbols++;

	int nBitsNew = nSymbols * m_bitsPerSymbol;

	// Pack filler bits with false (or anything)
	if (nBitsNew > nBitsOrig) {
		bits.set_size(nBitsNew, true);

		for (int i = nBitsOrig; i < nBitsNew; i++)
			bits[i] = false;
	}

	symbols.set_size(nSymbols, false);

	for (int i = 0; i < nSymbols; i++) {
		int index = i * m_bitsPerSymbol;

		bvec word = bits(index, index + m_bitsPerSymbol - 1);

		for (int j = 0; j < m_mAry; j++) {
			bvec grayBits = m_bitMap.get_row(j);

			wxASSERT(grayBits.size() == word.size());

			if (grayBits == word) {
				symbols[i] = j;
				break;
			}
		}
	}
}

double* CFSKModem::demodulate(double* bins) const
{
	wxASSERT(bins != NULL);

	data.set_size(m_bitsPerSymbol, false);
	data.clear();

	for (int j = 0; j < m_mAry; j++) {
		bvec bits = m_bitMap.get_row(j);

		double toneVal = bins[j];

		for (int k = 0; k < m_bitsPerSymbol; k++)
			data[k] += bits[k] ? toneVal : -toneVal;
	}
}
