/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "MessagePreferences.h"

const int BORDER_SIZE = 5;

CMessagePreferences::CMessagePreferences(wxWindow* parent, int id, const wxString* messages, int count, int maxLength) :
wxPanel(parent, id),
m_messages(NULL),
m_count(count)
{
	wxASSERT(messages != NULL);
	wxASSERT(m_count > 0);
	wxASSERT(maxLength > 0);

	wxBoxSizer* sizer = new wxBoxSizer(wxHORIZONTAL);

	wxBoxSizer* messageSizer = new wxBoxSizer(wxVERTICAL);

	m_messages = new CMessageTextCtrl*[m_count];

	for (int i = 0; i < m_count; i++) {
		m_messages[i] = new CMessageTextCtrl(this, -1, messages[i], true, wxDefaultPosition, wxSize(200, -1));
		m_messages[i]->SetMaxLength(maxLength);
		messageSizer->Add(m_messages[i], 0, wxALL, BORDER_SIZE);
	}

	sizer->Add(messageSizer, 0, wxALL, BORDER_SIZE);

	wxStaticText* label = new wxStaticText(this, -1, wxT("%M - My Call\n%T - To Radio\n%R - My Report\n%L - My Locator\n\nEverything\nelse is sent\nas is"));
	sizer->Add(label, 0, wxALL | wxALIGN_CENTRE_VERTICAL | wxALIGN_RIGHT, BORDER_SIZE);

	SetAutoLayout(true);

	sizer->Fit(this);
	sizer->SetSizeHints(this);

	SetSizer(sizer);
}

CMessagePreferences::~CMessagePreferences()
{
}

bool CMessagePreferences::isValid(int n) const
{
	wxASSERT(n >= 0 && n < m_count);

	return m_messages[n]->Validate();
}

wxString CMessagePreferences::getMessage(int n) const
{
	wxASSERT(n >= 0 && n < m_count);

	return m_messages[n]->GetValue();
}
