/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	JT6MFrame_H
#define	JT6MFrame_H

#include <wx/wx.h>
#include <wx/listctrl.h>
#include <wx/notebook.h>
#include <wx/spinctrl.h>

#include "commongui/RecordControl.h"
#include "commongui/TransmitControl.h"
#include "commongui/RemoteControl.h"
#include "commongui/MessageControl.h"
#include "commongui/ErrorEvent.h"
#include "commongui/ClockPanel.h"

#include "jt6m/JT6MLevels.h"
#include "jt6m/JT6MMessage.h"

#include "JT6MDisplay.h"
#include "JT6MLevelEvent.h"
#include "JT6MMessageEvent.h"
#include "JT6MSettingsControl.h"

class CJT6MFrame : public wxFrame {
    public:
	CJT6MFrame();
	virtual ~CJT6MFrame();

	virtual void onOpen(const wxCommandEvent& event);
	virtual void onSaving(const wxCommandEvent& event);
	virtual void onDelete(const wxCommandEvent& event);
	virtual void onQuit(const wxCommandEvent& event);
	virtual void onPreferences(const wxCommandEvent& event);
	virtual void onAbout(const wxCommandEvent& event);

	virtual void onRecord(const wxCommandEvent& event);
	virtual void onTXOrder(const wxCommandEvent& event);
	virtual void onTXEnable(const wxCommandEvent& event);
	virtual void onUpdate(const wxCommandEvent& event);
	virtual void onMinLength(const wxSpinEvent& event);
	virtual void onText(const wxCommandEvent& event);
	virtual void onMessage(const wxCommandEvent& event);

	virtual void onCardLevels(const CJT6MLevelEvent& event);
	virtual void onFileLevels(const CJT6MLevelEvent& event);

	virtual void onCardMessage(const CJT6MMessageEvent& event);
	virtual void onFileMessage(const CJT6MMessageEvent& event);

	virtual void onError(const CErrorEvent& event);

	virtual void showCardLevels(CJT6MLevels* levels);
	virtual void showFileLevels(CJT6MLevels* levels);

	virtual void showCardMessage(CJT6MMessage* message);
	virtual void showFileMessage(CJT6MMessage* message);

	virtual void error(const wxString& error);

    private:
	CJT6MDisplay*         m_cardDisplay;
	CJT6MDisplay*         m_fileDisplay;
	CRecordControl*       m_record;
	CTransmitControl*     m_transmit;
	CRemoteControl*       m_remote;
	CClockPanel*          m_clock;
	CJT6MSettingsControl* m_settings;
	CMessageControl*      m_message;
	int                   m_messageNo;

	DECLARE_EVENT_TABLE()

	wxMenuBar* createMenuBar();
};

#endif
